/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;

public class DockerCredentialHelper {
    private final String serverUrl;
    private final String credentialHelperSuffix;

    DockerCredentialHelper(String string, String string2) {
        this.serverUrl = string;
        this.credentialHelperSuffix = string2;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Authorization retrieve() throws IOException, NonexistentServerUrlDockerCredentialHelperException, NonexistentDockerCredentialHelperException {
        try {
            String string = "docker-credential-" + this.credentialHelperSuffix;
            String[] stringArray = new String[]{string, "get"};
            Process process = new ProcessBuilder(stringArray).start();
            try (Closeable closeable = process.getOutputStream();){
                ((OutputStream)closeable).write(this.serverUrl.getBytes(StandardCharsets.UTF_8));
            }
            closeable = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
            var5_6 = null;
            try {
                String string2 = CharStreams.toString((Readable)((Object)closeable));
                if (string2.contains("credentials not found in native keychain")) {
                    throw new NonexistentServerUrlDockerCredentialHelperException(string, this.serverUrl, string2);
                }
                if (string2.isEmpty()) {
                    InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);
                    Throwable throwable = null;
                    try {
                        try {
                            String string3 = CharStreams.toString((Readable)inputStreamReader);
                            throw new NonexistentServerUrlDockerCredentialHelperException(string, this.serverUrl, string3);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable3) {
                        if (inputStreamReader != null) {
                            if (throwable != null) {
                                try {
                                    inputStreamReader.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                            } else {
                                inputStreamReader.close();
                            }
                        }
                        throw throwable3;
                    }
                }
                try {
                    DockerCredentialsTemplate dockerCredentialsTemplate = JsonTemplateMapper.readJson(string2, DockerCredentialsTemplate.class);
                    if (dockerCredentialsTemplate.Username == null || dockerCredentialsTemplate.Secret == null) {
                        throw new NonexistentServerUrlDockerCredentialHelperException(string, this.serverUrl, string2);
                    }
                    Authorization authorization = Authorizations.withBasicCredentials(dockerCredentialsTemplate.Username, dockerCredentialsTemplate.Secret);
                    return authorization;
                }
                catch (JsonProcessingException jsonProcessingException) {
                    try {
                        throw new NonexistentServerUrlDockerCredentialHelperException(string, this.serverUrl, string2);
                    }
                    catch (Throwable throwable) {
                        var5_6 = throwable;
                        throw throwable;
                    }
                }
            }
            finally {
                if (closeable != null) {
                    if (var5_6 != null) {
                        try {
                            ((InputStreamReader)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((InputStreamReader)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage() == null) {
                throw iOException;
            }
            if (iOException.getMessage().contains("No such file or directory") || iOException.getMessage().contains("cannot find the file")) {
                throw new NonexistentDockerCredentialHelperException(this.credentialHelperSuffix, iOException);
            }
            throw iOException;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class DockerCredentialsTemplate
    implements JsonTemplate {
        @Nullable
        private String Username;
        @Nullable
        private String Secret;

        private DockerCredentialsTemplate() {
        }
    }
}

