/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.ErrorCodes;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import javax.annotation.Nullable;

class RegistryErrorExceptionBuilder {
    @Nullable
    private final Throwable cause;
    private final StringBuilder errorMessageBuilder = new StringBuilder();
    private boolean firstErrorReason = true;

    private static String getReason(@Nullable String string, @Nullable String string2) {
        if (string2 == null) {
            string2 = "no details";
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            ErrorCodes errorCodes = ErrorCodes.valueOf(string);
            if (errorCodes == ErrorCodes.MANIFEST_INVALID || errorCodes == ErrorCodes.BLOB_UNKNOWN) {
                return string2 + " (something went wrong)";
            }
            if (errorCodes == ErrorCodes.MANIFEST_UNKNOWN || errorCodes == ErrorCodes.TAG_INVALID || errorCodes == ErrorCodes.MANIFEST_UNVERIFIED) {
                return string2;
            }
            return "other: " + string2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "unknown: " + string2;
        }
    }

    RegistryErrorExceptionBuilder(String string, @Nullable Throwable throwable) {
        this.cause = throwable;
        this.errorMessageBuilder.append("Tried to ");
        this.errorMessageBuilder.append(string);
        this.errorMessageBuilder.append(" but failed because: ");
    }

    RegistryErrorExceptionBuilder(String string) {
        this(string, null);
    }

    RegistryErrorExceptionBuilder addReason(ErrorEntryTemplate errorEntryTemplate) {
        String string = RegistryErrorExceptionBuilder.getReason(errorEntryTemplate.getCode(), errorEntryTemplate.getMessage());
        this.addReason(string);
        return this;
    }

    RegistryErrorExceptionBuilder addReason(String string) {
        if (!this.firstErrorReason) {
            this.errorMessageBuilder.append(", ");
        }
        this.errorMessageBuilder.append(string);
        this.firstErrorReason = false;
        return this;
    }

    RegistryErrorException build() {
        this.errorMessageBuilder.append(" | If this is a bug, please file an issue at https://github.com/GoogleContainerTools/jib/issues/new");
        return new RegistryErrorException(this.errorMessageBuilder.toString(), this.cause);
    }
}

