/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Authorizations;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class RegistryAuthenticator {
    private final String authenticationUrlBase;
    @Nullable
    private Authorization authorization;

    @Nullable
    static RegistryAuthenticator fromAuthenticationMethod(String string, String string2) throws RegistryAuthenticationFailedException, MalformedURLException {
        if (string.matches("^Basic .*")) {
            return null;
        }
        if (!string.matches("^Bearer .*")) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(string, "Bearer");
        }
        Pattern pattern = Pattern.compile("realm=\"(.*?)\"");
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(string, "realm");
        }
        String string3 = matcher.group(1);
        Pattern pattern2 = Pattern.compile("service=\"(.*?)\"");
        Matcher matcher2 = pattern2.matcher(string);
        if (!matcher2.find()) {
            throw RegistryAuthenticator.newRegistryAuthenticationFailedException(string, "service");
        }
        String string4 = matcher2.group(1);
        return new RegistryAuthenticator(string3, string4, string2);
    }

    private static RegistryAuthenticationFailedException newRegistryAuthenticationFailedException(String string, String string2) {
        return new RegistryAuthenticationFailedException("'" + string2 + "' was not found in the 'WWW-Authenticate' header, tried to parse: " + string);
    }

    RegistryAuthenticator(String string, String string2, String string3) throws MalformedURLException {
        this.authenticationUrlBase = string + "?service=" + string2 + "&scope=repository:" + string3 + ":";
    }

    public RegistryAuthenticator setAuthorization(@Nullable Authorization authorization) {
        this.authorization = authorization;
        return this;
    }

    public Authorization authenticatePull() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull");
    }

    public Authorization authenticatePush() throws RegistryAuthenticationFailedException {
        return this.authenticate("pull,push");
    }

    @VisibleForTesting
    URL getAuthenticationUrl(String string) throws MalformedURLException {
        return new URL(this.authenticationUrlBase + string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Authorization authenticate(String string) throws RegistryAuthenticationFailedException {
        try {
            URL uRL = this.getAuthenticationUrl(string);
            try (Connection connection = new Connection(uRL);){
                Response response;
                String string2;
                AuthenticationResponseTemplate authenticationResponseTemplate;
                Request.Builder builder = Request.builder();
                if (this.authorization != null) {
                    builder.setAuthorization(this.authorization);
                }
                if ((authenticationResponseTemplate = JsonTemplateMapper.readJson(string2 = Blobs.writeToString((response = connection.get(builder.build())).getBody()), AuthenticationResponseTemplate.class)).token == null) {
                    throw new RegistryAuthenticationFailedException("Did not get token in authentication response from " + uRL);
                }
                Authorization authorization = Authorizations.withBearerToken(authenticationResponseTemplate.token);
                return authorization;
            }
        }
        catch (IOException iOException) {
            throw new RegistryAuthenticationFailedException(iOException);
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class AuthenticationResponseTemplate
    implements JsonTemplate {
        @Nullable
        private String token;

        private AuthenticationResponseTemplate() {
        }
    }
}

