/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.OCIManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class ManifestPuller<T extends ManifestTemplate>
implements RegistryEndpointProvider<T> {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final String imageTag;
    private final Class<T> manifestTemplateClass;

    ManifestPuller(RegistryEndpointProperties registryEndpointProperties, String string, Class<T> clazz) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.imageTag = string;
        this.manifestTemplateClass = clazz;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        if (this.manifestTemplateClass.equals(V21ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v1+json");
        }
        if (this.manifestTemplateClass.equals(V22ManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.docker.distribution.manifest.v2+json");
        }
        if (this.manifestTemplateClass.equals(OCIManifestTemplate.class)) {
            return Collections.singletonList("application/vnd.oci.image.manifest.v1+json");
        }
        return Arrays.asList("application/vnd.oci.image.manifest.v1+json", "application/vnd.docker.distribution.manifest.v2+json", "application/vnd.docker.distribution.manifest.v1+json");
    }

    @Override
    public T handleResponse(Response response) throws IOException, UnknownManifestFormatException {
        return this.getManifestTemplateFromJson(Blobs.writeToString(response.getBody()));
    }

    @Override
    public URL getApiRoute(String string) throws MalformedURLException {
        return new URL(string + this.registryEndpointProperties.getImageName() + "/manifests/" + this.imageTag);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull image manifest for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + ":" + this.imageTag;
    }

    private T getManifestTemplateFromJson(String string) throws IOException, UnknownManifestFormatException {
        ObjectNode objectNode = (ObjectNode)new ObjectMapper().readValue(string, ObjectNode.class);
        if (!objectNode.has("schemaVersion")) {
            throw new UnknownManifestFormatException("Cannot find field 'schemaVersion' in manifest");
        }
        if (!this.manifestTemplateClass.equals(ManifestTemplate.class)) {
            return (T)((ManifestTemplate)JsonTemplateMapper.readJson(string, this.manifestTemplateClass));
        }
        int n = objectNode.get("schemaVersion").asInt(-1);
        if (n == -1) {
            throw new UnknownManifestFormatException("`schemaVersion` field is not an integer");
        }
        if (n == 1) {
            return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(string, V21ManifestTemplate.class)));
        }
        if (n == 2) {
            String string2 = objectNode.get("mediaType").asText();
            if ("application/vnd.docker.distribution.manifest.v2+json".equals(string2)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(string, V22ManifestTemplate.class)));
            }
            if ("application/vnd.oci.image.manifest.v1+json".equals(string2)) {
                return (T)((ManifestTemplate)this.manifestTemplateClass.cast(JsonTemplateMapper.readJson(string, OCIManifestTemplate.class)));
            }
            throw new UnknownManifestFormatException("Unknown mediaType: " + string2);
        }
        throw new UnknownManifestFormatException("Unknown schemaVersion: " + n + " - only 1 and 2 are supported");
    }
}

