/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import java.lang.reflect.InvocationTargetException;
import java.util.List;

public class ImageToJsonTranslator {
    private final Image<CachedLayer> image;

    public ImageToJsonTranslator(Image<CachedLayer> image) {
        this.image = image;
    }

    public Blob getContainerConfigurationBlob() {
        ContainerConfigurationTemplate containerConfigurationTemplate = new ContainerConfigurationTemplate();
        for (CachedLayer cachedLayer : this.image.getLayers()) {
            containerConfigurationTemplate.addLayerDiffId(cachedLayer.getDiffId());
        }
        containerConfigurationTemplate.setContainerEnvironment((List<String>)this.image.getEnvironment());
        containerConfigurationTemplate.setContainerEntrypoint((List<String>)this.image.getEntrypoint());
        containerConfigurationTemplate.setContainerCmd((List<String>)this.image.getJavaArguments());
        return JsonTemplateMapper.toBlob(containerConfigurationTemplate);
    }

    public <T extends BuildableManifestTemplate> T getManifestTemplate(Class<T> clazz, BlobDescriptor blobDescriptor) {
        try {
            BuildableManifestTemplate buildableManifestTemplate = (BuildableManifestTemplate)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            DescriptorDigest descriptorDigest = blobDescriptor.getDigest();
            long l = blobDescriptor.getSize();
            buildableManifestTemplate.setContainerConfiguration(l, descriptorDigest);
            for (CachedLayer cachedLayer : this.image.getLayers()) {
                buildableManifestTemplate.addLayer(cachedLayer.getBlobDescriptor().getSize(), cachedLayer.getBlobDescriptor().getDigest());
            }
            return (T)buildableManifestTemplate;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            throw new IllegalArgumentException(clazz + " cannot be instantiated", reflectiveOperationException);
        }
    }
}

