/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import java.io.Closeable;
import java.io.IOException;
import java.net.URL;
import javax.annotation.Nullable;

public class Connection
implements Closeable {
    private HttpRequestFactory requestFactory = new ApacheHttpTransport().createRequestFactory();
    @Nullable
    private HttpResponse httpResponse;
    private final GenericUrl url;

    public Connection(URL uRL) {
        this.url = new GenericUrl(uRL);
    }

    @Override
    public void close() throws IOException {
        if (this.httpResponse == null) {
            return;
        }
        this.httpResponse.disconnect();
    }

    public Response get(Request request) throws IOException {
        return this.send("GET", request);
    }

    public Response post(Request request) throws IOException {
        return this.send("POST", request);
    }

    public Response put(Request request) throws IOException {
        return this.send("PUT", request);
    }

    public Response send(String string, Request request) throws IOException {
        this.httpResponse = this.requestFactory.buildRequest(string, this.url, (HttpContent)request.getHttpContent()).setHeaders(request.getHeaders()).execute();
        return new Response(this.httpResponse);
    }
}

