/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;

class LayerMetadata {
    private List<String> sourceFiles;
    private final FileTime lastModifiedTime;

    static LayerMetadata from(List<Path> list, FileTime fileTime) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (Path path : list) {
            arrayList.add(path.toString());
        }
        return new LayerMetadata(arrayList, fileTime);
    }

    LayerMetadata(List<String> list, FileTime fileTime) {
        this.sourceFiles = list;
        this.lastModifiedTime = fileTime;
    }

    List<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public FileTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    @VisibleForTesting
    void setSourceFiles(List<String> list) {
        this.sourceFiles = list;
    }
}

