/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.builder.steps.StepsRunner;
import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.concurrent.ExecutionException;

public class BuildSteps {
    private static final String DESCRIPTION_FOR_DOCKER_REGISTRY = "Building and pushing image";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY = "Containerizing application to %s...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY = "Built and pushed image as \u001b[36m%s\u001b[0m";
    private static final String DESCRIPTION_FOR_DOCKER_DAEMON = "Building image to Docker daemon";
    private static final String STARTUP_MESSAGE_FORMAT_FOR_DOCKER_DAEMON = "Containerizing application to Docker daemon as %s...";
    private static final String SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_DAEMON = "Built image to Docker daemon as \u001b[36m%s\u001b[0m";
    private final String description;
    private final BuildConfiguration buildConfiguration;
    private final SourceFilesConfiguration sourceFilesConfiguration;
    private final Caches.Initializer cachesInitializer;
    private final String startupMessage;
    private final String successMessage;
    private final StepsRunnerConsumer stepsRunnerConsumer;

    public static BuildSteps forBuildToDockerRegistry(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Caches.Initializer initializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_REGISTRY, buildConfiguration, sourceFilesConfiguration, initializer, String.format(STARTUP_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY, buildConfiguration.getTargetImageReference()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_REGISTRY, buildConfiguration.getTargetImageReference()), stepsRunner -> stepsRunner.runRetrieveTargetRegistryCredentialsStep().runRetrieveBaseRegistryCredentialsStep().runAuthenticatePushStep().runAuthenticatePullStep().runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runPushBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep(BuildSteps.getEntrypoint(buildConfiguration, sourceFilesConfiguration)).runPushContainerConfigurationStep().runPushApplicationLayersStep().runFinalizingPushStep().runPushImageStep().waitOnPushImageStep());
    }

    public static BuildSteps forBuildToDockerDaemon(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Caches.Initializer initializer) {
        return new BuildSteps(DESCRIPTION_FOR_DOCKER_DAEMON, buildConfiguration, sourceFilesConfiguration, initializer, String.format(STARTUP_MESSAGE_FORMAT_FOR_DOCKER_DAEMON, buildConfiguration.getTargetImageReference()), String.format(SUCCESS_MESSAGE_FORMAT_FOR_DOCKER_DAEMON, buildConfiguration.getTargetImageReference()), stepsRunner -> stepsRunner.runRetrieveBaseRegistryCredentialsStep().runAuthenticatePullStep().runPullBaseImageStep().runPullAndCacheBaseImageLayersStep().runBuildAndCacheApplicationLayerSteps().runBuildImageStep(BuildSteps.getEntrypoint(buildConfiguration, sourceFilesConfiguration)).runFinalizingBuildStep().runBuildTarballAndLoadDockerStep().waitOnBuildTarballAndLoadDockerStep());
    }

    private static ImmutableList<String> getEntrypoint(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration) {
        return EntrypointBuilder.makeEntrypoint(sourceFilesConfiguration, buildConfiguration.getJvmFlags(), buildConfiguration.getMainClass());
    }

    private BuildSteps(String string, BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Caches.Initializer initializer, String string2, String string3, StepsRunnerConsumer stepsRunnerConsumer) {
        this.description = string;
        this.buildConfiguration = buildConfiguration;
        this.sourceFilesConfiguration = sourceFilesConfiguration;
        this.cachesInitializer = initializer;
        this.startupMessage = string2;
        this.successMessage = string3;
        this.stepsRunnerConsumer = stepsRunnerConsumer;
    }

    public BuildConfiguration getBuildConfiguration() {
        return this.buildConfiguration;
    }

    public SourceFilesConfiguration getSourceFilesConfiguration() {
        return this.sourceFilesConfiguration;
    }

    public String getStartupMessage() {
        return this.startupMessage;
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void run() throws InterruptedException, ExecutionException, CacheMetadataCorruptedException, IOException, CacheDirectoryNotOwnedException {
        this.buildConfiguration.getBuildLogger().lifecycle("");
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), this.description);
             Caches caches = this.cachesInitializer.init();){
            Cache cache = caches.getBaseCache();
            Cache cache2 = caches.getApplicationCache();
            this.stepsRunnerConsumer.accept(new StepsRunner(this.buildConfiguration, this.sourceFilesConfiguration, cache, cache2));
        }
        this.buildConfiguration.getBuildLogger().lifecycle("");
        this.buildConfiguration.getBuildLogger().lifecycle("Container entrypoint set to " + BuildSteps.getEntrypoint(this.buildConfiguration, this.sourceFilesConfiguration));
    }

    @FunctionalInterface
    private static interface StepsRunnerConsumer {
        public void accept(StepsRunner var1) throws ExecutionException, InterruptedException;
    }
}

