/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

class FileBlob
implements Blob {
    private final Path file;

    FileBlob(Path path) {
        this.file = path;
    }

    @Override
    public BlobDescriptor writeTo(OutputStream outputStream) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(this.file, new OpenOption[0]));){
            BlobDescriptor blobDescriptor = BlobDescriptor.fromPipe(bufferedInputStream, outputStream);
            return blobDescriptor;
        }
    }
}

