/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib;

import com.google.cloud.tools.jib.builder.BuildLogger;
import java.io.Closeable;
import javax.annotation.Nullable;

public class Timer
implements Closeable {
    private final BuildLogger buildLogger;
    private final int depth;
    @Nullable
    private String label;
    private long startTime = System.nanoTime();

    public Timer(BuildLogger buildLogger, String string) {
        this(buildLogger, string, 0);
    }

    private Timer(BuildLogger buildLogger, String string, int n) {
        this.buildLogger = buildLogger;
        this.label = string;
        this.depth = n;
        if (buildLogger != null) {
            buildLogger.debug(this.getTabs().append("TIMING\t").append(string));
            if (n == 0) {
                buildLogger.info("RUNNING\t" + string);
            }
        }
    }

    public Timer subTimer(String string) {
        return new Timer(this.buildLogger, string, this.depth + 1);
    }

    public void lap(@Nullable String string) {
        if (this.label == null) {
            throw new IllegalStateException("Tried to lap Timer after closing");
        }
        if (this.buildLogger != null) {
            double d = (double)((System.nanoTime() - this.startTime) / 1000L) / 1000.0;
            this.buildLogger.debug(this.getTabs().append("TIMED\t").append(this.label).append(" : ").append(d).append(" ms"));
            if (this.depth == 0) {
                this.buildLogger.info(this.label + " : " + d + " ms");
            }
        }
        this.label = string;
        this.startTime = System.nanoTime();
    }

    private StringBuilder getTabs() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.depth; ++i) {
            stringBuilder.append("\t");
        }
        return stringBuilder;
    }

    @Override
    public void close() {
        this.lap(null);
    }
}

