/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry.credentials.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DockerConfigTemplate
implements JsonTemplate {
    private final Map<String, AuthTemplate> auths = new HashMap<String, AuthTemplate>();
    @Nullable
    private String credsStore;
    private final Map<String, String> credHelpers = new HashMap<String, String>();

    @Nullable
    public String getAuthFor(String string) {
        if (!this.auths.containsKey(string)) {
            return null;
        }
        return this.auths.get(string).auth;
    }

    @Nullable
    public String getCredentialHelperFor(String string) {
        if (this.credsStore != null && (this.auths.containsKey(string) || this.auths.containsKey("https://" + string))) {
            return this.credsStore;
        }
        if (this.credHelpers.containsKey(string)) {
            return this.credHelpers.get(string);
        }
        return null;
    }

    @VisibleForTesting
    DockerConfigTemplate addAuth(String string, @Nullable String string2) {
        AuthTemplate authTemplate = new AuthTemplate();
        authTemplate.auth = string2;
        this.auths.put(string, authTemplate);
        return this;
    }

    @VisibleForTesting
    DockerConfigTemplate setCredsStore(String string) {
        this.credsStore = string;
        return this;
    }

    @VisibleForTesting
    DockerConfigTemplate addCredHelper(String string, String string2) {
        this.credHelpers.put(string, string2);
        return this;
    }

    private static class AuthTemplate
    implements JsonTemplate {
        @Nullable
        private String auth;

        private AuthTemplate() {
        }
    }
}

