/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.http.Connection;
import com.google.cloud.tools.jib.http.Request;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.AuthenticationMethodRetriever;
import com.google.cloud.tools.jib.registry.BlobChecker;
import com.google.cloud.tools.jib.registry.BlobPuller;
import com.google.cloud.tools.jib.registry.ManifestPuller;
import com.google.cloud.tools.jib.registry.ManifestPusher;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.cloud.tools.jib.registry.RegistryNoResponseException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.cloud.tools.jib.registry.json.ErrorEntryTemplate;
import com.google.cloud.tools.jib.registry.json.ErrorResponseTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Iterator;
import javax.annotation.Nullable;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.http.NoHttpResponseException;

public class RegistryClient {
    private Timer parentTimer = new Timer(new BuildLogger(){

        @Override
        public void debug(CharSequence charSequence) {
        }

        @Override
        public void info(CharSequence charSequence) {
        }

        @Override
        public void warn(CharSequence charSequence) {
        }

        @Override
        public void error(CharSequence charSequence) {
        }

        @Override
        public void lifecycle(CharSequence charSequence) {
        }
    }, "NULL TIMER");
    private static final String PROTOCOL = "https";
    @Nullable
    private static String userAgentSuffix;
    @Nullable
    private final Authorization authorization;
    private final RegistryEndpointProperties registryEndpointProperties;

    public RegistryClient setTimer(Timer timer) {
        this.parentTimer = timer;
        return this;
    }

    public static void setUserAgentSuffix(@Nullable String string) {
        userAgentSuffix = string;
    }

    @VisibleForTesting
    static String getUserAgent() {
        String string = RegistryClient.class.getPackage().getImplementationVersion();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("jib");
        if (string != null) {
            stringBuilder.append(" ").append(string);
        }
        if (userAgentSuffix != null) {
            stringBuilder.append(" ").append(userAgentSuffix);
        }
        return stringBuilder.toString();
    }

    public RegistryClient(@Nullable Authorization authorization, String string, String string2) {
        this.authorization = authorization;
        this.registryEndpointProperties = new RegistryEndpointProperties(string, string2);
    }

    @Nullable
    public RegistryAuthenticator getRegistryAuthenticator() throws IOException, RegistryException {
        return this.callRegistryEndpoint(new AuthenticationMethodRetriever(this.registryEndpointProperties));
    }

    public <T extends ManifestTemplate> T pullManifest(String string, Class<T> clazz) throws IOException, RegistryException {
        ManifestPuller<T> manifestPuller = new ManifestPuller<T>(this.registryEndpointProperties, string, clazz);
        ManifestTemplate manifestTemplate = (ManifestTemplate)this.callRegistryEndpoint(manifestPuller);
        if (manifestTemplate == null) {
            throw new IllegalStateException("ManifestPuller#handleResponse does not return null");
        }
        return (T)manifestTemplate;
    }

    public ManifestTemplate pullManifest(String string) throws IOException, RegistryException {
        return this.pullManifest(string, ManifestTemplate.class);
    }

    public void pushManifest(BuildableManifestTemplate buildableManifestTemplate, String string) throws IOException, RegistryException {
        this.callRegistryEndpoint(new ManifestPusher(this.registryEndpointProperties, buildableManifestTemplate, string));
    }

    @Nullable
    public BlobDescriptor checkBlob(DescriptorDigest descriptorDigest) throws IOException, RegistryException {
        BlobChecker blobChecker = new BlobChecker(this.registryEndpointProperties, descriptorDigest);
        return this.callRegistryEndpoint(blobChecker);
    }

    public Void pullBlob(DescriptorDigest descriptorDigest, OutputStream outputStream) throws RegistryException, IOException {
        BlobPuller blobPuller = new BlobPuller(this.registryEndpointProperties, descriptorDigest, outputStream);
        return this.callRegistryEndpoint(blobPuller);
    }

    /*
     * Exception decompiling
     */
    public boolean pushBlob(DescriptorDigest var1_1, Blob var2_2) throws IOException, RegistryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    String getApiRouteBase() {
        return "https://" + this.registryEndpointProperties.getServerUrl() + "/v2/";
    }

    @Nullable
    private <T> T callRegistryEndpoint(RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        return this.callRegistryEndpoint(null, registryEndpointProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T callRegistryEndpoint(@Nullable URL uRL, RegistryEndpointProvider<T> registryEndpointProvider) throws IOException, RegistryException {
        if (uRL == null) {
            uRL = registryEndpointProvider.getApiRoute(this.getApiRouteBase());
        }
        try (Connection connection = new Connection(uRL);){
            Request throwable = Request.builder().setAuthorization(this.authorization).setUserAgent(RegistryClient.getUserAgent()).setAccept(registryEndpointProvider.getAccept()).setBody(registryEndpointProvider.getContent()).build();
            Response registryErrorExceptionBuilder = connection.send(registryEndpointProvider.getHttpMethod(), throwable);
            T t = registryEndpointProvider.handleResponse(registryErrorExceptionBuilder);
            return t;
        }
        catch (HttpResponseException httpResponseException) {
            try {
                return registryEndpointProvider.handleHttpResponseException(httpResponseException);
            }
            catch (HttpResponseException httpResponseException2) {
                if (httpResponseException2.getStatusCode() == 400 || httpResponseException2.getStatusCode() == 404 || httpResponseException2.getStatusCode() == 405) {
                    ErrorResponseTemplate errorResponseTemplate = JsonTemplateMapper.readJson(httpResponseException2.getContent(), ErrorResponseTemplate.class);
                    RegistryErrorExceptionBuilder registryErrorExceptionBuilder = new RegistryErrorExceptionBuilder(registryEndpointProvider.getActionDescription(), httpResponseException2);
                    Iterator<ErrorEntryTemplate> iterator = errorResponseTemplate.getErrors().iterator();
                    while (iterator.hasNext()) {
                        ErrorEntryTemplate errorEntryTemplate = iterator.next();
                        registryErrorExceptionBuilder.addReason(errorEntryTemplate);
                    }
                    throw registryErrorExceptionBuilder.build();
                }
                if (httpResponseException2.getStatusCode() == 401) throw new RegistryUnauthorizedException(this.registryEndpointProperties.getServerUrl(), this.registryEndpointProperties.getImageName(), httpResponseException2);
                if (httpResponseException2.getStatusCode() == 403) {
                    throw new RegistryUnauthorizedException(this.registryEndpointProperties.getServerUrl(), this.registryEndpointProperties.getImageName(), httpResponseException2);
                }
                if (httpResponseException2.getStatusCode() != 307) throw httpResponseException2;
                return this.callRegistryEndpoint(new URL(httpResponseException2.getHeaders().getLocation()), registryEndpointProvider);
            }
        }
        catch (NoHttpResponseException noHttpResponseException) {
            throw new RegistryNoResponseException(noHttpResponseException);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            GenericUrl genericUrl = new GenericUrl(uRL);
            genericUrl.setScheme("http");
            return this.callRegistryEndpoint(genericUrl.toURL(), registryEndpointProvider);
        }
    }
}

