/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.Nullable;

public abstract class RegistryAuthenticators {
    public static RegistryAuthenticator forDockerHub(String string) throws RegistryAuthenticationFailedException {
        try {
            return new RegistryAuthenticator("https://auth.docker.io/token", "registry.docker.io", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegistryAuthenticationFailedException(malformedURLException);
        }
    }

    @Nullable
    public static RegistryAuthenticator forOther(String string, String string2) throws RegistryAuthenticationFailedException, IOException, RegistryException {
        try {
            RegistryClient registryClient = new RegistryClient(null, string, string2);
            return registryClient.getRegistryAuthenticator();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RegistryAuthenticationFailedException(malformedURLException);
        }
    }
}

