/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.cloud.tools.jib.json.ListOfJsonTemplate;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class JsonTemplateMapper {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public static <T extends JsonTemplate> T readJsonFromFile(Path path, Class<T> clazz) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(Files.newInputStream(path, new OpenOption[0]), clazz));
    }

    public static <T extends JsonTemplate> T readJson(String string, Class<T> clazz) throws IOException {
        return (T)((JsonTemplate)objectMapper.readValue(string, clazz));
    }

    public static <T extends ListOfJsonTemplate> List<T> readListOfJson(String string, Class<T> clazz) throws IOException {
        return (List)objectMapper.readValue(string, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, clazz));
    }

    public static Blob toBlob(JsonTemplate jsonTemplate) {
        return JsonTemplateMapper.toBlob((Object)jsonTemplate);
    }

    public static Blob toBlob(ListOfJsonTemplate listOfJsonTemplate) {
        return JsonTemplateMapper.toBlob(listOfJsonTemplate.getList());
    }

    private static Blob toBlob(Object object) {
        return Blobs.from(outputStream -> objectMapper.writeValue(outputStream, object));
    }

    private JsonTemplateMapper() {
    }
}

