/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public class V21ManifestTemplate
implements ManifestTemplate {
    public static final String MEDIA_TYPE = "application/vnd.docker.distribution.manifest.v1+json";
    private final int schemaVersion = 1;
    private final List<LayerObjectTemplate> fsLayers = new ArrayList<LayerObjectTemplate>();
    private final List<V1CompatibilityTemplate> history = new ArrayList<V1CompatibilityTemplate>();

    public List<DescriptorDigest> getLayerDigests() {
        ArrayList<DescriptorDigest> arrayList = new ArrayList<DescriptorDigest>();
        for (LayerObjectTemplate layerObjectTemplate : this.fsLayers) {
            arrayList.add(layerObjectTemplate.blobSum);
        }
        return arrayList;
    }

    @Override
    public int getSchemaVersion() {
        return 1;
    }

    public List<LayerObjectTemplate> getFsLayers() {
        return Collections.unmodifiableList(this.fsLayers);
    }

    @Nullable
    @VisibleForTesting
    String getV1Compatibility(int n) {
        return this.history.get(n).v1Compatibility;
    }

    private static class V1CompatibilityTemplate
    implements JsonTemplate {
        @Nullable
        private String v1Compatibility;

        private V1CompatibilityTemplate() {
        }
    }

    static class LayerObjectTemplate
    implements JsonTemplate {
        @Nullable
        private DescriptorDigest blobSum;

        LayerObjectTemplate() {
        }

        @Nullable
        DescriptorDigest getDigest() {
            return this.blobSum;
        }
    }
}

