/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.DigestOnlyLayer;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.ReferenceLayer;
import com.google.cloud.tools.jib.image.ReferenceNoDiffIdLayer;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import java.util.ArrayList;
import java.util.List;

public class JsonToImageTranslator {
    public static Image<Layer> toImage(V21ManifestTemplate v21ManifestTemplate) throws LayerPropertyNotFoundException {
        Image.Builder<DigestOnlyLayer> builder = Image.builder();
        for (DescriptorDigest descriptorDigest : v21ManifestTemplate.getLayerDigests()) {
            builder.addLayer(new DigestOnlyLayer(descriptorDigest));
        }
        return builder.build();
    }

    public static Image<Layer> toImage(BuildableManifestTemplate buildableManifestTemplate, ContainerConfigurationTemplate containerConfigurationTemplate) throws LayerCountMismatchException, LayerPropertyNotFoundException {
        ArrayList<ReferenceNoDiffIdLayer> arrayList = new ArrayList<ReferenceNoDiffIdLayer>();
        for (BuildableManifestTemplate.ContentDescriptorTemplate object2 : buildableManifestTemplate.getLayers()) {
            if (object2.getDigest() == null) {
                throw new IllegalArgumentException("All layers in the manifest template must have digest set");
            }
            arrayList.add(new ReferenceNoDiffIdLayer(new BlobDescriptor(object2.getSize(), object2.getDigest())));
        }
        List<DescriptorDigest> list = containerConfigurationTemplate.getDiffIds();
        if (arrayList.size() != list.size()) {
            throw new LayerCountMismatchException("Mismatch between image manifest and container configuration");
        }
        Image.Builder<ReferenceLayer> builder = Image.builder();
        for (int i = 0; i < arrayList.size(); ++i) {
            ReferenceNoDiffIdLayer referenceNoDiffIdLayer = (ReferenceNoDiffIdLayer)arrayList.get(i);
            DescriptorDigest descriptorDigest = (DescriptorDigest)list.get(i);
            builder.addLayer(new ReferenceLayer(referenceNoDiffIdLayer.getBlobDescriptor(), descriptorDigest));
        }
        if (containerConfigurationTemplate.getContainerEntrypoint() != null) {
            builder.setEntrypoint(containerConfigurationTemplate.getContainerEntrypoint());
        }
        if (containerConfigurationTemplate.getContainerCmd() != null) {
            builder.setJavaArguments(containerConfigurationTemplate.getContainerCmd());
        }
        if (containerConfigurationTemplate.getContainerEnvironment() != null) {
            for (String string : containerConfigurationTemplate.getContainerEnvironment()) {
                builder.addEnvironmentVariableDefinition(string);
            }
        }
        return builder.build();
    }

    private JsonToImageTranslator() {
    }
}

