/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.json.JsonTemplate;
import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ContainerConfigurationTemplate
implements JsonTemplate {
    private String architecture = "amd64";
    private String os = "linux";
    private final ConfigurationObjectTemplate config = new ConfigurationObjectTemplate();
    private final RootFilesystemObjectTemplate rootfs = new RootFilesystemObjectTemplate();

    public void setContainerEnvironment(List<String> list) {
        this.config.Env = list;
    }

    public void setContainerEntrypoint(List<String> list) {
        this.config.Entrypoint = list;
    }

    public void setContainerCmd(List<String> list) {
        this.config.Cmd = list;
    }

    public void addLayerDiffId(DescriptorDigest descriptorDigest) {
        this.rootfs.diff_ids.add(descriptorDigest);
    }

    List<DescriptorDigest> getDiffIds() {
        return this.rootfs.diff_ids;
    }

    @Nullable
    List<String> getContainerEnvironment() {
        return this.config.Env;
    }

    @Nullable
    List<String> getContainerEntrypoint() {
        return this.config.Entrypoint;
    }

    @Nullable
    List<String> getContainerCmd() {
        return this.config.Cmd;
    }

    @VisibleForTesting
    DescriptorDigest getLayerDiffId(int n) {
        return (DescriptorDigest)this.rootfs.diff_ids.get(n);
    }

    private static class RootFilesystemObjectTemplate
    implements JsonTemplate {
        private final String type = "layers";
        private final List<DescriptorDigest> diff_ids = new ArrayList<DescriptorDigest>();

        private RootFilesystemObjectTemplate() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class ConfigurationObjectTemplate
    implements JsonTemplate {
        @Nullable
        private List<String> Env;
        @Nullable
        private List<String> Entrypoint;
        @Nullable
        private List<String> Cmd;

        private ConfigurationObjectTemplate() {
        }
    }
}

