/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.InvalidImageReferenceException;
import com.google.common.base.Strings;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ImageReference {
    private static final String DOCKER_HUB_REGISTRY = "registry.hub.docker.com";
    private static final String DEFAULT_TAG = "latest";
    private static final String LIBRARY_REPOSITORY_PREFIX = "library/";
    private static final String REGISTRY_COMPONENT_REGEX = "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))";
    private static final String REGISTRY_REGEX = String.format("%s(?:\\.%s)*(?::\\d+)?", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))", "(?:[a-zA-Z\\d]|(?:[a-zA-Z\\d][a-zA-Z\\d-]*[a-zA-Z\\d]))");
    private static final String REPOSITORY_COMPONENT_REGEX = "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*";
    private static final String REPOSITORY_REGEX = String.format("(?:%s/)*%s", "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*", "[a-z\\d]+(?:(?:[_.]|__|[-]*)[a-z\\d]+)*");
    private static final String TAG_REGEX = "[\\w][\\w.-]{0,127}";
    private static final String REFERENCE_REGEX = String.format("^(?:(%s)/)?(%s)(?:(?::(%s))|(?:@(%s)))?$", REGISTRY_REGEX, REPOSITORY_REGEX, "[\\w][\\w.-]{0,127}", "sha256:[a-f0-9]{64}");
    private static final Pattern REFERENCE_PATTERN = Pattern.compile(REFERENCE_REGEX);
    private final String registry;
    private final String repository;
    private final String tag;

    public static ImageReference parse(String string) throws InvalidImageReferenceException {
        Matcher matcher = REFERENCE_PATTERN.matcher(string);
        if (!matcher.find() || matcher.groupCount() < 4) {
            throw new InvalidImageReferenceException(string);
        }
        String string2 = matcher.group(1);
        String string3 = matcher.group(2);
        String string4 = matcher.group(3);
        String string5 = matcher.group(4);
        if (Strings.isNullOrEmpty((String)string2)) {
            string2 = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)string3)) {
            throw new InvalidImageReferenceException(string);
        }
        if (!(string2.contains(".") || string2.contains(":") || "localhost".equals(string2))) {
            string3 = string2 + "/" + string3;
            string2 = DOCKER_HUB_REGISTRY;
        }
        if (DOCKER_HUB_REGISTRY.equals(string2) && string3.indexOf(47) < 0) {
            string3 = LIBRARY_REPOSITORY_PREFIX + string3;
        }
        if (!Strings.isNullOrEmpty((String)string4)) {
            if (!Strings.isNullOrEmpty((String)string5)) {
                throw new InvalidImageReferenceException(string);
            }
        } else {
            string4 = !Strings.isNullOrEmpty((String)string5) ? string5 : DEFAULT_TAG;
        }
        return new ImageReference(string2, string3, string4);
    }

    public static ImageReference of(@Nullable String string, String string2, @Nullable String string3) {
        if (Strings.isNullOrEmpty((String)string)) {
            string = DOCKER_HUB_REGISTRY;
        }
        if (Strings.isNullOrEmpty((String)string3)) {
            string3 = DEFAULT_TAG;
        }
        return new ImageReference(string, string2, string3);
    }

    public static boolean isValidRegistry(String string) {
        return string.matches(REGISTRY_REGEX);
    }

    public static boolean isValidRepository(String string) {
        return string.matches(REPOSITORY_REGEX);
    }

    public static boolean isValidTag(String string) {
        return string.matches(TAG_REGEX);
    }

    private ImageReference(String string, String string2, String string3) {
        this.registry = string;
        this.repository = string2;
        this.tag = string3;
    }

    public String getRegistry() {
        return this.registry;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getTag() {
        return this.tag;
    }

    public boolean usesDefaultTag() {
        return DEFAULT_TAG.equals(this.tag);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!DOCKER_HUB_REGISTRY.equals(this.registry)) {
            stringBuilder.append(this.registry).append('/').append(this.repository);
        } else if (this.repository.startsWith(LIBRARY_REPOSITORY_PREFIX)) {
            stringBuilder.append(this.repository.substring(LIBRARY_REPOSITORY_PREFIX.length()));
        } else {
            stringBuilder.append(this.repository);
        }
        if (!DEFAULT_TAG.equals(this.tag)) {
            stringBuilder.append(':').append(this.tag);
        }
        return stringBuilder.toString();
    }

    public String toStringWithTag() {
        return this + (this.usesDefaultTag() ? ":latest" : "");
    }
}

