/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Iterator;
import javax.annotation.Nullable;

public class ImageLayers<T extends Layer>
implements Iterable<T> {
    private final ImmutableList<T> layers;
    private final ImmutableSet<DescriptorDigest> layerDigests;

    public static <U extends Layer> Builder<U> builder() {
        return new Builder();
    }

    private ImageLayers(ImmutableList<T> immutableList, ImmutableSet<DescriptorDigest> immutableSet) {
        this.layers = immutableList;
        this.layerDigests = immutableSet;
    }

    public ImmutableList<T> getLayers() {
        return this.layers;
    }

    public int size() {
        return this.layers.size();
    }

    public boolean isEmpty() {
        return this.layers.isEmpty();
    }

    public T get(int n) {
        return (T)((Layer)this.layers.get(n));
    }

    @Nullable
    public T get(DescriptorDigest descriptorDigest) throws LayerPropertyNotFoundException {
        if (!this.has(descriptorDigest)) {
            return null;
        }
        for (Layer layer : this.layers) {
            if (!layer.getBlobDescriptor().getDigest().equals(descriptorDigest)) continue;
            return (T)layer;
        }
        throw new IllegalStateException("Layer digest exists but layer not found");
    }

    public boolean has(DescriptorDigest descriptorDigest) {
        return this.layerDigests.contains((Object)descriptorDigest);
    }

    @Override
    public Iterator<T> iterator() {
        return this.getLayers().iterator();
    }

    public static class Builder<T extends Layer> {
        private final ImmutableList.Builder<T> layersBuilder = ImmutableList.builder();
        private final ImmutableSet.Builder<DescriptorDigest> layerDigestsBuilder = ImmutableSet.builder();
        @Nullable
        private T lastLayer;

        public Builder<T> add(T t) throws LayerPropertyNotFoundException {
            if (!this.isSameAsLastLayer(t)) {
                this.layerDigestsBuilder.add((Object)t.getBlobDescriptor().getDigest());
                this.layersBuilder.add(t);
                this.lastLayer = t;
            }
            return this;
        }

        public <U extends T> Builder<T> addAll(ImageLayers<U> imageLayers) throws LayerPropertyNotFoundException {
            for (Layer layer : imageLayers) {
                this.add(layer);
            }
            return this;
        }

        public ImageLayers<T> build() {
            return new ImageLayers(this.layersBuilder.build(), this.layerDigestsBuilder.build());
        }

        private boolean isSameAsLastLayer(T t) throws LayerPropertyNotFoundException {
            return this.lastLayer != null && t.getBlobDescriptor().getDigest().equals(this.lastLayer.getBlobDescriptor().getDigest());
        }
    }
}

