/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;

public class Image<T extends Layer> {
    private final ImageLayers<T> layers;
    private final ImmutableList<String> environmentBuilder;
    private final ImmutableList<String> entrypoint;
    private final ImmutableList<String> javaArguments;

    public static <T extends Layer> Builder<T> builder() {
        return new Builder();
    }

    private Image(ImageLayers<T> imageLayers, ImmutableList<String> immutableList, ImmutableList<String> immutableList2, ImmutableList<String> immutableList3) {
        this.layers = imageLayers;
        this.environmentBuilder = immutableList;
        this.entrypoint = immutableList2;
        this.javaArguments = immutableList3;
    }

    public ImmutableList<String> getEnvironment() {
        return this.environmentBuilder;
    }

    public ImmutableList<String> getEntrypoint() {
        return this.entrypoint;
    }

    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    public ImmutableList<T> getLayers() {
        return this.layers.getLayers();
    }

    public static class Builder<T extends Layer> {
        private final ImageLayers.Builder<T> imageLayersBuilder = ImageLayers.builder();
        private final ImmutableList.Builder<String> environmentBuilder = ImmutableList.builder();
        private ImmutableList<String> entrypoint = ImmutableList.of();
        private ImmutableList<String> javaArguments = ImmutableList.of();

        public Builder<T> setEnvironment(Map<String, String> map) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.setEnvironmentVariable(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public Builder<T> setEnvironmentVariable(String string, String string2) {
            this.environmentBuilder.add((Object)(string + "=" + string2));
            return this;
        }

        public Builder<T> addEnvironmentVariableDefinition(String string) {
            this.environmentBuilder.add((Object)string);
            return this;
        }

        public Builder<T> setEntrypoint(List<String> list) {
            this.entrypoint = ImmutableList.copyOf(list);
            return this;
        }

        public Builder<T> setJavaArguments(List<String> list) {
            this.javaArguments = ImmutableList.copyOf(list);
            return this;
        }

        public Builder<T> addLayer(T t) throws LayerPropertyNotFoundException {
            this.imageLayersBuilder.add(t);
            return this;
        }

        public Image<T> build() {
            return new Image(this.imageLayersBuilder.build(), this.environmentBuilder.build(), ImmutableList.copyOf(this.entrypoint), ImmutableList.copyOf(this.javaArguments));
        }
    }
}

