/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.http;

import com.google.api.client.http.HttpResponse;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import java.io.IOException;
import java.util.List;

public class Response {
    private final HttpResponse httpResponse;

    Response(HttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.getStatusCode();
    }

    public List<String> getHeader(String string) {
        return this.httpResponse.getHeaders().getHeaderStringValues(string);
    }

    public long getContentLength() throws NumberFormatException {
        String string = this.httpResponse.getHeaders().getFirstHeaderStringValue("Content-Length");
        if (string == null) {
            return -1L;
        }
        try {
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            return -1L;
        }
    }

    public Blob getBody() throws IOException {
        return Blobs.from(this.httpResponse.getContent());
    }
}

