/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.hash;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import java.io.IOException;
import java.io.OutputStream;
import java.security.DigestException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class CountingDigestOutputStream
extends DigestOutputStream {
    private static final String SHA_256_ALGORITHM = "SHA-256";
    private long totalBytes = 0L;

    public CountingDigestOutputStream(OutputStream outputStream) {
        super(outputStream, null);
        try {
            this.setMessageDigest(MessageDigest.getInstance(SHA_256_ALGORITHM));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA-256 algorithm implementation not found - might be a broken JVM");
        }
    }

    public BlobDescriptor toBlobDescriptor() {
        try {
            byte[] byArray = this.digest.digest();
            StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
            for (byte by : byArray) {
                stringBuilder.append(String.format("%02x", by));
            }
            String string = stringBuilder.toString();
            DescriptorDigest descriptorDigest = DescriptorDigest.fromHash(string);
            return new BlobDescriptor(this.totalBytes, descriptorDigest);
        }
        catch (DigestException digestException) {
            throw new RuntimeException("SHA-256 algorithm produced invalid hash: " + digestException.getMessage(), digestException);
        }
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        super.write(byArray, n, n2);
        this.totalBytes += (long)n2;
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        ++this.totalBytes;
    }
}

