/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public class UserCacheHome {
    private static final Logger logger = Logger.getLogger(UserCacheHome.class.getName());

    public static Path getCacheHome() {
        return UserCacheHome.getCacheHome(System.getProperties(), System.getenv());
    }

    @VisibleForTesting
    static Path getCacheHome(Properties properties, Map<String, String> map) {
        String string = map.get("XDG_CACHE_HOME");
        if (string != null && !string.trim().isEmpty()) {
            return Paths.get(string, new String[0]);
        }
        String string2 = properties.getProperty("user.home");
        Path path = Paths.get(string2, new String[0]);
        Path path2 = path.resolve(".cache");
        String string3 = properties.getProperty("os.name");
        String string4 = string3.toLowerCase(Locale.ENGLISH);
        if (string4.contains("linux")) {
            return path2;
        }
        if (string4.contains("windows")) {
            String string5 = map.get("LOCALAPPDATA");
            if (string5 == null || string5.trim().isEmpty()) {
                logger.warning("LOCALAPPDATA environment is invalid or missing");
                return path2;
            }
            Path path3 = Paths.get(string5, new String[0]);
            if (!Files.exists(path3, new LinkOption[0])) {
                logger.warning(path3 + " does not exist");
                return path2;
            }
            return path3;
        }
        if (string4.contains("mac") || string4.contains("darwin")) {
            Path path4 = path.resolve("Library").resolve("Application Support");
            if (!Files.exists(path4, new LinkOption[0])) {
                logger.warning(path4 + " does not exist");
                return path2;
            }
            return path4;
        }
        throw new IllegalStateException("Unknown OS: " + string3);
    }

    private UserCacheHome() {
    }
}

