/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.builder.EntrypointBuilder;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.filesystem.FileOperations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.io.Resources;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import javax.annotation.Nullable;

public class DockerContextGenerator {
    private final SourceFilesConfiguration sourceFilesConfiguration;
    @Nullable
    private String baseImage;
    private List<String> jvmFlags = Collections.emptyList();
    private String mainClass = "";
    private List<String> javaArguments = Collections.emptyList();

    public DockerContextGenerator(SourceFilesConfiguration sourceFilesConfiguration) {
        this.sourceFilesConfiguration = sourceFilesConfiguration;
    }

    public DockerContextGenerator setBaseImage(String string) {
        this.baseImage = string;
        return this;
    }

    public DockerContextGenerator setJvmFlags(List<String> list) {
        this.jvmFlags = list;
        return this;
    }

    public DockerContextGenerator setMainClass(String string) {
        this.mainClass = string;
        return this;
    }

    public DockerContextGenerator setJavaArguments(List<String> list) {
        this.javaArguments = list;
        return this;
    }

    public void generate(Path path) throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        try {
            Files.deleteIfExists(path);
        }
        catch (DirectoryNotEmptyException directoryNotEmptyException) {
            MoreFiles.deleteDirectoryContents((Path)path, (RecursiveDeleteOption[])new RecursiveDeleteOption[0]);
            Files.delete(path);
        }
        Files.createDirectory(path, new FileAttribute[0]);
        Path path2 = path.resolve("libs");
        Path path3 = path.resolve("resources");
        Path path4 = path.resolve("classes");
        Files.createDirectory(path2, new FileAttribute[0]);
        Files.createDirectory(path3, new FileAttribute[0]);
        Files.createDirectory(path4, new FileAttribute[0]);
        FileOperations.copy(this.sourceFilesConfiguration.getDependenciesFiles(), path2);
        FileOperations.copy(this.sourceFilesConfiguration.getResourcesFiles(), path3);
        FileOperations.copy(this.sourceFilesConfiguration.getClassesFiles(), path4);
        Files.write(path.resolve("Dockerfile"), this.makeDockerfile().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    @VisibleForTesting
    String makeDockerfile() throws IOException {
        Preconditions.checkNotNull((Object)this.baseImage);
        String string = Resources.toString((URL)Resources.getResource((String)"DockerfileTemplate"), (Charset)StandardCharsets.UTF_8);
        return string.replace("@@BASE_IMAGE@@", this.baseImage).replace("@@DEPENDENCIES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getDependenciesPathOnImage()).replace("@@RESOURCES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getResourcesPathOnImage()).replace("@@CLASSES_PATH_ON_IMAGE@@", this.sourceFilesConfiguration.getClassesPathOnImage()).replace("@@ENTRYPOINT@@", DockerContextGenerator.joinAsJsonArray(EntrypointBuilder.makeEntrypoint(this.sourceFilesConfiguration, this.jvmFlags, this.mainClass))).replace("@@CMD@@", DockerContextGenerator.joinAsJsonArray(this.javaArguments));
    }

    @VisibleForTesting
    static String joinAsJsonArray(List<String> list) {
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        for (String string : list) {
            if (!bl) {
                stringBuilder.append(',');
            }
            string = string.replaceAll("\"", Matcher.quoteReplacement("\\\""));
            stringBuilder.append('\"').append(string).append('\"');
            bl = false;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

