/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.Cache;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.filesystem.UserCacheHome;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class Caches
implements Closeable {
    private final Cache baseCache;
    private final Cache applicationCache;

    public static Initializer newInitializer(Path path) {
        return new Initializer(path);
    }

    private Caches(Path path, Path path2) throws CacheMetadataCorruptedException, IOException {
        this.applicationCache = Cache.init(path2);
        this.baseCache = Files.isSameFile(path, path2) ? this.applicationCache : Cache.init(path);
    }

    public Cache getBaseCache() {
        return this.baseCache;
    }

    public Cache getApplicationCache() {
        return this.applicationCache;
    }

    @Override
    public void close() throws IOException {
        this.applicationCache.close();
        if (this.baseCache != this.applicationCache) {
            this.baseCache.close();
        }
    }

    public static class Initializer {
        private static final Path DEFAULT_BASE_CACHE_DIRECTORY = UserCacheHome.getCacheHome().resolve("google-cloud-tools-java").resolve("jib");
        private static final String OWNERSHIP_FILE_NAME = ".jib";
        private final Path applicationCacheDirectory;
        private Path baseCacheDirectory = DEFAULT_BASE_CACHE_DIRECTORY;

        @VisibleForTesting
        static void ensureOwnership(Path path) throws CacheDirectoryNotOwnedException, IOException {
            Path path2 = path.resolve(OWNERSHIP_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                if (!Files.exists(path2, new LinkOption[0])) {
                    throw new CacheDirectoryNotOwnedException(path);
                }
            } else {
                Files.createDirectories(path, new FileAttribute[0]);
                Files.createFile(path2, new FileAttribute[0]);
            }
        }

        private Initializer(Path path) {
            this.applicationCacheDirectory = path;
        }

        public Initializer setBaseCacheDirectory(Path path) {
            this.baseCacheDirectory = path;
            return this;
        }

        public Caches init() throws CacheMetadataCorruptedException, IOException, CacheDirectoryNotOwnedException {
            if (DEFAULT_BASE_CACHE_DIRECTORY.equals(this.baseCacheDirectory)) {
                Initializer.ensureOwnership(DEFAULT_BASE_CACHE_DIRECTORY);
            }
            return new Caches(this.baseCacheDirectory, this.applicationCacheDirectory);
        }
    }
}

