/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.image.ImageLayers;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

class CacheMetadata {
    private final ImageLayers.Builder<CachedLayerWithMetadata> layersBuilder = ImageLayers.builder();

    CacheMetadata() {
    }

    synchronized ImageLayers<CachedLayerWithMetadata> getLayers() {
        return this.layersBuilder.build();
    }

    synchronized void addLayer(CachedLayerWithMetadata cachedLayerWithMetadata) throws LayerPropertyNotFoundException {
        this.layersBuilder.add(cachedLayerWithMetadata);
    }

    synchronized LayerFilter filterLayers() {
        return new LayerFilter(this.layersBuilder.build());
    }

    static class LayerFilter {
        private final ImageLayers<CachedLayerWithMetadata> layers;
        @Nullable
        private ImmutableList<Path> sourceFiles;

        private LayerFilter(ImageLayers<CachedLayerWithMetadata> imageLayers) {
            this.layers = imageLayers;
        }

        LayerFilter bySourceFiles(ImmutableList<Path> immutableList) {
            this.sourceFiles = immutableList;
            return this;
        }

        ImageLayers<CachedLayerWithMetadata> filter() throws CacheMetadataCorruptedException {
            try {
                ImageLayers.Builder builder = ImageLayers.builder();
                for (CachedLayerWithMetadata cachedLayerWithMetadata : this.layers) {
                    if (this.sourceFiles != null) {
                        if (cachedLayerWithMetadata.getMetadata() == null) continue;
                        List<String> list = cachedLayerWithMetadata.getMetadata().getSourceFiles();
                        if (list != null) {
                            ArrayList<Path> arrayList = new ArrayList<Path>();
                            for (String string : list) {
                                arrayList.add(Paths.get(string, new String[0]));
                            }
                            if (!arrayList.equals(this.sourceFiles)) continue;
                        }
                    }
                    builder.add(cachedLayerWithMetadata);
                }
                return builder.build();
            }
            catch (LayerPropertyNotFoundException layerPropertyNotFoundException) {
                throw new CacheMetadataCorruptedException(layerPropertyNotFoundException);
            }
        }
    }
}

