/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CacheMetadataTranslator;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nullable;

public class Cache
implements Closeable {
    private final Path cacheDirectory;
    private final CacheMetadata cacheMetadata;

    public static Cache init(Path path) throws NotDirectoryException, CacheMetadataCorruptedException {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new NotDirectoryException("The cache can only write to a directory");
        }
        CacheMetadata cacheMetadata = Cache.loadCacheMetadata(path);
        return new Cache(path, cacheMetadata);
    }

    private static CacheMetadata loadCacheMetadata(Path path) throws CacheMetadataCorruptedException {
        Path path2 = path.resolve("metadata.json");
        if (!Files.exists(path2, new LinkOption[0])) {
            return new CacheMetadata();
        }
        try {
            CacheMetadataTemplate cacheMetadataTemplate = JsonTemplateMapper.readJsonFromFile(path2, CacheMetadataTemplate.class);
            return CacheMetadataTranslator.fromTemplate(cacheMetadataTemplate, path);
        }
        catch (IOException iOException) {
            throw new CacheMetadataCorruptedException(iOException);
        }
    }

    private Cache(Path path, CacheMetadata cacheMetadata) {
        this.cacheDirectory = path;
        this.cacheMetadata = cacheMetadata;
    }

    @Override
    public void close() throws IOException {
        this.saveCacheMetadata(this.cacheDirectory);
    }

    void addLayerToMetadata(CachedLayer cachedLayer, @Nullable LayerMetadata layerMetadata) throws LayerPropertyNotFoundException {
        this.cacheMetadata.addLayer(new CachedLayerWithMetadata(cachedLayer, layerMetadata));
    }

    @VisibleForTesting
    Path getCacheDirectory() {
        return this.cacheDirectory;
    }

    @VisibleForTesting
    CacheMetadata getMetadata() {
        return this.cacheMetadata;
    }

    private void saveCacheMetadata(Path path) throws IOException {
        Path path2 = path.resolve("metadata.json");
        CacheMetadataTemplate cacheMetadataTemplate = CacheMetadataTranslator.toTemplate(this.cacheMetadata);
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(Files.newOutputStream(path2, new OpenOption[0]));){
            JsonTemplateMapper.toBlob(cacheMetadataTemplate).writeTo(bufferedOutputStream);
        }
    }
}

