/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.http.Authorization;
import com.google.cloud.tools.jib.registry.credentials.DockerConfigCredentialRetriever;
import com.google.cloud.tools.jib.registry.credentials.DockerCredentialHelperFactory;
import com.google.cloud.tools.jib.registry.credentials.NonexistentDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.NonexistentServerUrlDockerCredentialHelperException;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

class RetrieveRegistryCredentialsStep
implements AsyncStep<Authorization>,
Callable<Authorization> {
    private static final String DESCRIPTION = "Retrieving registry credentials for %s";
    private static final ImmutableMap<String, String> COMMON_CREDENTIAL_HELPERS = ImmutableMap.of((Object)"gcr.io", (Object)"gcr", (Object)"amazonaws.com", (Object)"ecr-login");
    private final BuildLogger buildLogger;
    private final String registry;
    @Nullable
    private final String credentialHelperSuffix;
    @Nullable
    private final RegistryCredentials knownRegistryCredentials;
    private final DockerCredentialHelperFactory dockerCredentialHelperFactory;
    private final DockerConfigCredentialRetriever dockerConfigCredentialRetriever;
    private final ListenableFuture<Authorization> listenableFuture;

    static RetrieveRegistryCredentialsStep forBaseImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getBaseImageRegistry(), buildConfiguration.getBaseImageCredentialHelperName(), buildConfiguration.getKnownBaseRegistryCredentials());
    }

    static RetrieveRegistryCredentialsStep forTargetImage(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration) {
        return new RetrieveRegistryCredentialsStep(listeningExecutorService, buildConfiguration.getBuildLogger(), buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageCredentialHelperName(), buildConfiguration.getKnownTargetRegistryCredentials());
    }

    @VisibleForTesting
    RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String string, @Nullable String string2, @Nullable RegistryCredentials registryCredentials, DockerCredentialHelperFactory dockerCredentialHelperFactory, DockerConfigCredentialRetriever dockerConfigCredentialRetriever) {
        this.buildLogger = buildLogger;
        this.registry = string;
        this.credentialHelperSuffix = string2;
        this.knownRegistryCredentials = registryCredentials;
        this.dockerCredentialHelperFactory = dockerCredentialHelperFactory;
        this.dockerConfigCredentialRetriever = dockerConfigCredentialRetriever;
        this.listenableFuture = listeningExecutorService.submit((Callable)this);
    }

    private RetrieveRegistryCredentialsStep(ListeningExecutorService listeningExecutorService, BuildLogger buildLogger, String string, @Nullable String string2, @Nullable RegistryCredentials registryCredentials) {
        this(listeningExecutorService, buildLogger, string, string2, registryCredentials, new DockerCredentialHelperFactory(string), new DockerConfigCredentialRetriever(string));
    }

    @Override
    public ListenableFuture<Authorization> getFuture() {
        return this.listenableFuture;
    }

    /*
     * Loose catch block
     */
    @Override
    @Nullable
    public Authorization call() throws IOException, NonexistentDockerCredentialHelperException {
        Authorization authorization;
        Throwable throwable;
        Timer timer;
        block35: {
            Authorization authorization2;
            block36: {
                block37: {
                    block32: {
                        block33: {
                            block34: {
                                block29: {
                                    Authorization authorization3;
                                    block30: {
                                        block31: {
                                            this.buildLogger.lifecycle(String.format(DESCRIPTION, this.registry) + "...");
                                            timer = new Timer(this.buildLogger, String.format(DESCRIPTION, this.registry));
                                            throwable = null;
                                            if (this.credentialHelperSuffix == null || (authorization = this.retrieveFromCredentialHelper(this.credentialHelperSuffix)) == null) break block29;
                                            authorization3 = authorization;
                                            if (timer == null) break block30;
                                            if (throwable == null) break block31;
                                            try {
                                                timer.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                            break block30;
                                        }
                                        timer.close();
                                    }
                                    return authorization3;
                                }
                                if (this.knownRegistryCredentials == null) break block32;
                                this.logGotCredentialsFrom(this.knownRegistryCredentials.getCredentialSource());
                                authorization = this.knownRegistryCredentials.getAuthorization();
                                if (timer == null) break block33;
                                if (throwable == null) break block34;
                                try {
                                    timer.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                break block33;
                            }
                            timer.close();
                        }
                        return authorization;
                    }
                    authorization = this.dockerConfigCredentialRetriever.retrieve();
                    if (authorization == null) break block35;
                    this.buildLogger.info("Using credentials from Docker config for " + this.registry);
                    authorization2 = authorization;
                    if (timer == null) break block36;
                    if (throwable == null) break block37;
                    try {
                        timer.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    break block36;
                }
                timer.close();
            }
            return authorization2;
        }
        try {
            block38: {
                break block38;
                catch (IOException iOException) {
                    this.buildLogger.info("Unable to parse Docker config");
                }
            }
            for (String string : COMMON_CREDENTIAL_HELPERS.keySet()) {
                if (!this.registry.endsWith(string)) continue;
                try {
                    String string2 = (String)COMMON_CREDENTIAL_HELPERS.get((Object)string);
                    if (string2 == null) {
                        throw new IllegalStateException("No COMMON_CREDENTIAL_HELPERS should be null");
                    }
                    Authorization authorization4 = this.retrieveFromCredentialHelper(string2);
                    if (authorization4 == null) continue;
                    Authorization authorization5 = authorization4;
                    return authorization5;
                }
                catch (NonexistentDockerCredentialHelperException nonexistentDockerCredentialHelperException) {
                    if (nonexistentDockerCredentialHelperException.getMessage() == null) continue;
                    this.buildLogger.warn(nonexistentDockerCredentialHelperException.getMessage());
                }
            }
            this.buildLogger.info("No credentials could be retrieved for registry " + this.registry);
            authorization = null;
            return authorization;
        }
        catch (Throwable throwable5) {
            throwable = throwable5;
            throw throwable5;
        }
        catch (Throwable throwable6) {
            throw throwable6;
        }
        finally {
            if (timer != null) {
                if (throwable != null) {
                    try {
                        timer.close();
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                } else {
                    timer.close();
                }
            }
        }
    }

    @Nullable
    @VisibleForTesting
    Authorization retrieveFromCredentialHelper(String string) throws NonexistentDockerCredentialHelperException, IOException {
        this.buildLogger.info("Checking credentials from docker-credential-" + string);
        try {
            Authorization authorization = this.dockerCredentialHelperFactory.withCredentialHelperSuffix(string).retrieve();
            this.logGotCredentialsFrom("docker-credential-" + string);
            return authorization;
        }
        catch (NonexistentServerUrlDockerCredentialHelperException nonexistentServerUrlDockerCredentialHelperException) {
            this.buildLogger.info("No credentials for " + this.registry + " in docker-credential-" + string);
            return null;
        }
    }

    private void logGotCredentialsFrom(String string) {
        this.buildLogger.info("Using " + string + " for " + this.registry);
    }
}

