/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.blob;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobWriter;
import com.google.cloud.tools.jib.blob.FileBlob;
import com.google.cloud.tools.jib.blob.InputStreamBlob;
import com.google.cloud.tools.jib.blob.StringBlob;
import com.google.cloud.tools.jib.blob.WriterBlob;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class Blobs {
    public static Blob from(InputStream inputStream) {
        return new InputStreamBlob(inputStream);
    }

    public static Blob from(Path path) {
        return new FileBlob(path);
    }

    public static Blob from(String string) {
        return new StringBlob(string);
    }

    public static Blob from(BlobWriter blobWriter) {
        return new WriterBlob(blobWriter);
    }

    public static String writeToString(Blob blob) throws IOException {
        return new String(Blobs.writeToByteArray(blob), StandardCharsets.UTF_8);
    }

    public static byte[] writeToByteArray(Blob blob) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        blob.writeTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private Blobs() {
    }
}

