/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.tar;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class TarStreamBuilder {
    private final LinkedHashMap<TarArchiveEntry, TarArchiveOutputStreamConsumer> archiveMap = new LinkedHashMap();

    private void writeEntriesAsTarArchive(OutputStream outputStream) throws IOException {
        try (TarArchiveOutputStream tarArchiveOutputStream = new TarArchiveOutputStream(outputStream);){
            tarArchiveOutputStream.setLongFileMode(3);
            for (Map.Entry<TarArchiveEntry, TarArchiveOutputStreamConsumer> entry : this.archiveMap.entrySet()) {
                tarArchiveOutputStream.putArchiveEntry((ArchiveEntry)entry.getKey());
                entry.getValue().accept(tarArchiveOutputStream);
                tarArchiveOutputStream.closeArchiveEntry();
            }
        }
    }

    public void addEntry(TarArchiveEntry tarArchiveEntry) {
        this.archiveMap.put(tarArchiveEntry, tarArchiveOutputStream -> {
            if (tarArchiveEntry.isFile()) {
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(tarArchiveEntry.getFile().toPath(), new OpenOption[0]));){
                    ByteStreams.copy((InputStream)bufferedInputStream, (OutputStream)tarArchiveOutputStream);
                }
            }
        });
    }

    public void addEntry(String string, String string2) {
        TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(string2);
        tarArchiveEntry.setSize((long)string.length());
        this.archiveMap.put(tarArchiveEntry, tarArchiveOutputStream -> tarArchiveOutputStream.write(string.getBytes(StandardCharsets.UTF_8)));
    }

    public Blob toBlob() {
        return Blobs.from(this::writeEntriesAsTarArchive);
    }

    @FunctionalInterface
    private static interface TarArchiveOutputStreamConsumer {
        public void accept(TarArchiveOutputStream var1) throws IOException;
    }
}

