/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.UnexpectedBlobDigestException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class BlobPuller
implements RegistryEndpointProvider<Void> {
    private final RegistryEndpointProperties registryEndpointProperties;
    private final DescriptorDigest blobDigest;
    private final OutputStream destinationOutputStream;

    BlobPuller(RegistryEndpointProperties registryEndpointProperties, DescriptorDigest descriptorDigest, OutputStream outputStream) {
        this.registryEndpointProperties = registryEndpointProperties;
        this.blobDigest = descriptorDigest;
        this.destinationOutputStream = outputStream;
    }

    @Override
    public Void handleResponse(Response response) throws IOException, UnexpectedBlobDigestException {
        try (OutputStream outputStream = this.destinationOutputStream;){
            BlobDescriptor blobDescriptor = response.getBody().writeTo(outputStream);
            if (!this.blobDigest.equals(blobDescriptor.getDigest())) {
                throw new UnexpectedBlobDigestException("The pulled BLOB has digest '" + blobDescriptor.getDigest() + "', but the request digest was '" + this.blobDigest + "'");
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    public URL getApiRoute(String string) throws MalformedURLException {
        return new URL(string + this.registryEndpointProperties.getImageName() + "/blobs/" + this.blobDigest);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "pull BLOB for " + this.registryEndpointProperties.getServerUrl() + "/" + this.registryEndpointProperties.getImageName() + " with digest " + this.blobDigest;
    }
}

