/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.registry;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.http.BlobHttpContent;
import com.google.cloud.tools.jib.http.Response;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryAuthenticator;
import com.google.cloud.tools.jib.registry.RegistryEndpointProperties;
import com.google.cloud.tools.jib.registry.RegistryEndpointProvider;
import com.google.cloud.tools.jib.registry.RegistryErrorException;
import com.google.cloud.tools.jib.registry.RegistryErrorExceptionBuilder;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

class AuthenticationMethodRetriever
implements RegistryEndpointProvider<RegistryAuthenticator> {
    private final RegistryEndpointProperties registryEndpointProperties;

    @Override
    @Nullable
    public BlobHttpContent getContent() {
        return null;
    }

    @Override
    public List<String> getAccept() {
        return Collections.emptyList();
    }

    @Override
    @Nullable
    public RegistryAuthenticator handleResponse(Response response) {
        return null;
    }

    @Override
    public URL getApiRoute(String string) throws MalformedURLException {
        return new URL(string);
    }

    @Override
    public String getHttpMethod() {
        return "GET";
    }

    @Override
    public String getActionDescription() {
        return "retrieve authentication method for " + this.registryEndpointProperties.getServerUrl();
    }

    @Override
    @Nullable
    public RegistryAuthenticator handleHttpResponseException(HttpResponseException httpResponseException) throws HttpResponseException, RegistryErrorException {
        if (httpResponseException.getStatusCode() != 401) {
            throw httpResponseException;
        }
        String string = httpResponseException.getHeaders().getAuthenticate();
        if (string == null) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), httpResponseException).addReason("'WWW-Authenticate' header not found").build();
        }
        try {
            return RegistryAuthenticator.fromAuthenticationMethod(string, this.registryEndpointProperties.getImageName());
        }
        catch (RegistryAuthenticationFailedException | MalformedURLException exception) {
            throw new RegistryErrorExceptionBuilder(this.getActionDescription(), exception).addReason("Failed get authentication method from 'WWW-Authenticate' header").build();
        }
    }

    AuthenticationMethodRetriever(RegistryEndpointProperties registryEndpointProperties) {
        this.registryEndpointProperties = registryEndpointProperties;
    }
}

