/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.image;

import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.image.UnwrittenLayer;
import com.google.cloud.tools.jib.tar.TarStreamBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class ReproducibleLayerBuilder {
    private final List<Path> sourceFiles;
    private final String extractionPath;

    public ReproducibleLayerBuilder(List<Path> list, String string) {
        this.sourceFiles = new ArrayList<Path>(list);
        this.extractionPath = string;
    }

    public UnwrittenLayer build() throws IOException {
        ArrayList<TarArchiveEntry> arrayList = new ArrayList<TarArchiveEntry>();
        for (Path object : this.sourceFiles) {
            if (Files.isDirectory(object, new LinkOption[0])) {
                new DirectoryWalker(object).filterRoot().walk(path2 -> {
                    StringBuilder stringBuilder = new StringBuilder(this.extractionPath);
                    Path path3 = object.getParent().relativize(path2);
                    for (Path path4 : path3) {
                        stringBuilder.append('/').append(path4);
                    }
                    arrayList.add(new TarArchiveEntry(path2.toFile(), stringBuilder.toString()));
                });
                continue;
            }
            TarArchiveEntry tarArchiveEntry = new TarArchiveEntry(object.toFile(), this.extractionPath + "/" + object.getFileName());
            arrayList.add(tarArchiveEntry);
        }
        TarStreamBuilder tarStreamBuilder = new TarStreamBuilder();
        arrayList.sort(Comparator.comparing(TarArchiveEntry::getName));
        for (TarArchiveEntry tarArchiveEntry : arrayList) {
            tarArchiveEntry.setModTime(0L);
            tarArchiveEntry.setGroupId(0);
            tarArchiveEntry.setUserId(0);
            tarArchiveEntry.setUserName("");
            tarArchiveEntry.setGroupName("");
            tarStreamBuilder.addEntry(tarArchiveEntry);
        }
        return new UnwrittenLayer(tarStreamBuilder.toBlob());
    }

    public List<Path> getSourceFiles() {
        return Collections.unmodifiableList(this.sourceFiles);
    }
}

