/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.filesystem.DirectoryWalker;
import com.google.cloud.tools.jib.frontend.MainClassInferenceException;
import com.google.cloud.tools.jib.frontend.ProjectProperties;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javax.annotation.Nullable;

public class MainClassFinder {
    public static String resolveMainClass(@Nullable String string, ProjectProperties projectProperties) throws MainClassInferenceException {
        BuildLogger buildLogger = projectProperties.getLogger();
        if (string == null) {
            buildLogger.info("Searching for main class... Add a 'mainClass' configuration to '" + projectProperties.getPluginName() + "' to improve build speed.");
            string = projectProperties.getMainClassFromJar();
            if (string == null || !BuildConfiguration.isValidJavaClass(string)) {
                buildLogger.debug("Could not find a valid main class specified in " + projectProperties.getJarPluginName() + "; attempting to infer main class.");
                try {
                    HashSet<Path> hashSet = new HashSet<Path>();
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (Path path : projectProperties.getSourceFilesConfiguration().getClassesFiles()) {
                        Path path2 = path.getParent();
                        if (hashSet.contains(path2)) continue;
                        hashSet.add(path2);
                        arrayList.addAll(MainClassFinder.findMainClasses(path2, buildLogger));
                    }
                    if (arrayList.size() == 1) {
                        string = (String)arrayList.get(0);
                    } else {
                        if (arrayList.size() == 0 && string == null) {
                            throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Main class was not found").forMainClassNotFound(projectProperties.getPluginName()));
                        }
                        if (arrayList.size() > 1 && string == null) {
                            throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Multiple valid main classes were found: " + String.join((CharSequence)", ", arrayList)).forMainClassNotFound(projectProperties.getPluginName()));
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new MainClassInferenceException(projectProperties.getMainClassHelpfulSuggestions("Failed to get main class").forMainClassNotFound(projectProperties.getPluginName()), iOException);
                }
            }
        }
        Preconditions.checkNotNull((Object)string);
        if (!BuildConfiguration.isValidJavaClass(string)) {
            buildLogger.warn("'mainClass' is not a valid Java class : " + string);
        }
        return string;
    }

    @VisibleForTesting
    static List<String> findMainClasses(Path path2, BuildLogger buildLogger) throws IOException {
        if (!Files.exists(path2, new LinkOption[0]) || !Files.isDirectory(path2, new LinkOption[0])) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        try {
            CtClass[] ctClassArray = new CtClass[]{classPool.get("java.lang.String[]")};
            new DirectoryWalker(path2).filter(path -> Files.isRegularFile(path, new LinkOption[0])).filter(path -> path.toString().endsWith(".class")).walk(path -> {
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    CtClass ctClass = classPool.makeClass(inputStream);
                    CtMethod ctMethod = ctClass.getDeclaredMethod("main", ctClassArray);
                    if (CtClass.voidType.equals(ctMethod.getReturnType()) && Modifier.isStatic(ctMethod.getModifiers()) && Modifier.isPublic(ctMethod.getModifiers())) {
                        arrayList.add(ctClass.getName());
                    }
                }
                catch (NotFoundException notFoundException) {
                }
                catch (IOException iOException) {
                    buildLogger.warn("Could not read class file: " + path);
                }
            });
            return arrayList;
        }
        catch (NotFoundException notFoundException) {
            throw new RuntimeException(notFoundException);
        }
    }

    private MainClassFinder() {
    }
}

