/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.frontend;

import com.google.api.client.http.HttpResponseException;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.builder.BuildSteps;
import com.google.cloud.tools.jib.builder.SourceFilesConfiguration;
import com.google.cloud.tools.jib.cache.CacheDirectoryNotOwnedException;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.Caches;
import com.google.cloud.tools.jib.frontend.BuildStepsExecutionException;
import com.google.cloud.tools.jib.frontend.CacheDirectoryCreationException;
import com.google.cloud.tools.jib.frontend.HelpfulSuggestions;
import com.google.cloud.tools.jib.registry.RegistryAuthenticationFailedException;
import com.google.cloud.tools.jib.registry.RegistryUnauthorizedException;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.ExecutionException;
import org.apache.http.conn.HttpHostConnectException;

public class BuildStepsRunner {
    private final BuildSteps buildSteps;

    public static BuildStepsRunner forBuildImage(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Path path, boolean bl) throws CacheDirectoryCreationException {
        Caches.Initializer initializer = BuildStepsRunner.getCacheInitializer(path, bl);
        return new BuildStepsRunner(BuildSteps.forBuildToDockerRegistry(buildConfiguration, sourceFilesConfiguration, initializer));
    }

    public static BuildStepsRunner forBuildToDockerDaemon(BuildConfiguration buildConfiguration, SourceFilesConfiguration sourceFilesConfiguration, Path path, boolean bl) throws CacheDirectoryCreationException {
        Caches.Initializer initializer = BuildStepsRunner.getCacheInitializer(path, bl);
        return new BuildStepsRunner(BuildSteps.forBuildToDockerDaemon(buildConfiguration, sourceFilesConfiguration, initializer));
    }

    private static Caches.Initializer getCacheInitializer(Path path, boolean bl) throws CacheDirectoryCreationException {
        if (!Files.exists(path, new LinkOption[0])) {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new CacheDirectoryCreationException(path, (Throwable)iOException);
            }
        }
        Caches.Initializer initializer = Caches.newInitializer(path);
        if (bl) {
            initializer.setBaseCacheDirectory(path);
        }
        return initializer;
    }

    private static void handleRegistryUnauthorizedException(RegistryUnauthorizedException registryUnauthorizedException, BuildConfiguration buildConfiguration, HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        boolean bl;
        if (registryUnauthorizedException.getHttpResponseException().getStatusCode() == 403) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forHttpStatusCodeForbidden(registryUnauthorizedException.getImageReference()), registryUnauthorizedException);
        }
        boolean bl2 = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getBaseImageRegistry());
        boolean bl3 = registryUnauthorizedException.getRegistry().equals(buildConfiguration.getTargetImageRegistry());
        boolean bl4 = buildConfiguration.getBaseImageCredentialHelperName() != null || buildConfiguration.getKnownBaseRegistryCredentials() != null;
        boolean bl5 = bl = buildConfiguration.getTargetImageCredentialHelperName() != null || buildConfiguration.getKnownTargetRegistryCredentials() != null;
        if (bl2 && !bl4) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForBaseImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        if (bl3 && !bl) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forNoCredentialHelpersDefinedForTargetImage(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
        }
        throw new BuildStepsExecutionException(helpfulSuggestions.forCredentialsNotCorrect(registryUnauthorizedException.getRegistry()), registryUnauthorizedException);
    }

    @VisibleForTesting
    BuildStepsRunner(BuildSteps buildSteps) {
        this.buildSteps = buildSteps;
    }

    public void build(HelpfulSuggestions helpfulSuggestions) throws BuildStepsExecutionException {
        try {
            BuildLogger buildLogger = this.buildSteps.getBuildConfiguration().getBuildLogger();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getStartupMessage());
            buildLogger.info("Containerizing application with the following files:");
            buildLogger.info("\tClasses:");
            this.buildSteps.getSourceFilesConfiguration().getClassesFiles().forEach(path -> buildLogger.info("\t\t" + path));
            buildLogger.info("\tResources:");
            this.buildSteps.getSourceFilesConfiguration().getResourcesFiles().forEach(path -> buildLogger.info("\t\t" + path));
            buildLogger.info("\tDependencies:");
            this.buildSteps.getSourceFilesConfiguration().getDependenciesFiles().forEach(path -> buildLogger.info("\t\t" + path));
            this.buildSteps.run();
            buildLogger.lifecycle("");
            buildLogger.lifecycle(this.buildSteps.getSuccessMessage());
        }
        catch (CacheMetadataCorruptedException cacheMetadataCorruptedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheMetadataCorrupted(), cacheMetadataCorruptedException);
        }
        catch (ExecutionException executionException) {
            BuildConfiguration buildConfiguration = this.buildSteps.getBuildConfiguration();
            if (executionException.getCause() instanceof HttpHostConnectException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forHttpHostConnect(), executionException.getCause());
            }
            if (executionException.getCause() instanceof RegistryUnauthorizedException) {
                BuildStepsRunner.handleRegistryUnauthorizedException((RegistryUnauthorizedException)executionException.getCause(), buildConfiguration, helpfulSuggestions);
            }
            if (executionException.getCause() instanceof RegistryAuthenticationFailedException && executionException.getCause().getCause() instanceof HttpResponseException) {
                BuildStepsRunner.handleRegistryUnauthorizedException(new RegistryUnauthorizedException(buildConfiguration.getTargetImageRegistry(), buildConfiguration.getTargetImageRepository(), (HttpResponseException)executionException.getCause().getCause()), buildConfiguration, helpfulSuggestions);
            }
            if (executionException.getCause() instanceof UnknownHostException) {
                throw new BuildStepsExecutionException(helpfulSuggestions.forUnknownHost(), executionException.getCause());
            }
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), executionException.getCause());
        }
        catch (IOException | InterruptedException exception) {
            throw new BuildStepsExecutionException(helpfulSuggestions.none(), exception);
        }
        catch (CacheDirectoryNotOwnedException cacheDirectoryNotOwnedException) {
            throw new BuildStepsExecutionException(helpfulSuggestions.forCacheDirectoryNotOwned(cacheDirectoryNotOwnedException.getCacheDirectory()), cacheDirectoryNotOwnedException);
        }
    }
}

