/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.filesystem;

import com.google.cloud.tools.jib.filesystem.PathConsumer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DirectoryWalker {
    private final Path rootDir;
    private Predicate<Path> pathFilter = path -> true;

    public DirectoryWalker(Path path2) throws NotDirectoryException {
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new NotDirectoryException(path2 + " is not a directory");
        }
        this.rootDir = path2;
    }

    public DirectoryWalker filter(Predicate<Path> predicate) {
        this.pathFilter = this.pathFilter.and(predicate);
        return this;
    }

    public DirectoryWalker filterRoot() {
        this.filter(path -> !path.equals(this.rootDir));
        return this;
    }

    public ImmutableList<Path> walk(PathConsumer pathConsumer) throws IOException {
        ImmutableList<Path> immutableList = this.walk();
        for (Path path : immutableList) {
            pathConsumer.accept(path);
        }
        return immutableList;
    }

    public ImmutableList<Path> walk() throws IOException {
        try (Stream<Path> stream = Files.walk(this.rootDir, new FileVisitOption[0]);){
            Stream<Path> stream2 = stream;
            if (this.pathFilter != null) {
                stream2 = stream.filter(this.pathFilter);
            }
            ImmutableList immutableList = (ImmutableList)stream2.sorted().collect(ImmutableList.toImmutableList());
            return immutableList;
        }
    }
}

