/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.docker;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.io.CharStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;

public class DockerClient {
    private final Function<List<String>, ProcessBuilder> processBuilderFactory;

    private static ProcessBuilder defaultProcessBuilder(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>(1 + list.size());
        arrayList.add("docker");
        arrayList.addAll(list);
        return new ProcessBuilder(arrayList);
    }

    public DockerClient() {
        this(DockerClient::defaultProcessBuilder);
    }

    @VisibleForTesting
    DockerClient(Function<List<String>, ProcessBuilder> function) {
        this.processBuilderFactory = function;
    }

    public boolean isDockerInstalled() {
        try {
            this.docker(new String[0]);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public String load(Blob blob) throws InterruptedException, IOException {
        Process process = this.docker("load");
        try (Closeable closeable = process.getOutputStream();){
            try {
                blob.writeTo((OutputStream)closeable);
            }
            catch (IOException iOException) {
                String string;
                try (InputStreamReader inputStreamReader = new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8);){
                    string = CharStreams.toString((Readable)inputStreamReader);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
                throw new IOException("'docker load' command failed with error: " + string, iOException);
            }
        }
        closeable = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        var4_4 = null;
        try {
            String string = CharStreams.toString((Readable)((Object)closeable));
            if (process.waitFor() != 0) {
                throw new IOException("'docker load' command failed with output: " + string);
            }
            String string2 = string;
            return string2;
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        finally {
            if (closeable != null) {
                if (var4_4 != null) {
                    try {
                        ((InputStreamReader)closeable).close();
                    }
                    catch (Throwable throwable) {
                        var4_4.addSuppressed(throwable);
                    }
                } else {
                    ((InputStreamReader)closeable).close();
                }
            }
        }
    }

    private Process docker(String ... stringArray) throws IOException {
        return this.processBuilderFactory.apply(Arrays.asList(stringArray)).start();
    }
}

