/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.image.DescriptorDigest;
import com.google.cloud.tools.jib.image.Layer;
import java.nio.file.Path;

public class CachedLayer
implements Layer {
    private final Path contentFile;
    private final BlobDescriptor blobDescriptor;
    private final DescriptorDigest diffId;

    public CachedLayer(Path path, BlobDescriptor blobDescriptor, DescriptorDigest descriptorDigest) {
        this.contentFile = path;
        this.blobDescriptor = blobDescriptor;
        this.diffId = descriptorDigest;
    }

    public Path getContentFile() {
        return this.contentFile;
    }

    @Override
    public Blob getBlob() {
        return Blobs.from(this.contentFile);
    }

    @Override
    public BlobDescriptor getBlobDescriptor() {
        return this.blobDescriptor;
    }

    @Override
    public DescriptorDigest getDiffId() {
        return this.diffId;
    }
}

