/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.cache;

import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.cache.CacheFiles;
import com.google.cloud.tools.jib.cache.CacheMetadata;
import com.google.cloud.tools.jib.cache.CacheMetadataCorruptedException;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.cache.CachedLayerWithMetadata;
import com.google.cloud.tools.jib.cache.LayerMetadata;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataLayerPropertiesObjectTemplate;
import com.google.cloud.tools.jib.cache.json.CacheMetadataTemplate;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import java.nio.file.Path;

public class CacheMetadataTranslator {
    static CacheMetadata fromTemplate(CacheMetadataTemplate cacheMetadataTemplate, Path path) throws CacheMetadataCorruptedException {
        try {
            CacheMetadata cacheMetadata = new CacheMetadata();
            for (CacheMetadataLayerObjectTemplate cacheMetadataLayerObjectTemplate : cacheMetadataTemplate.getLayers()) {
                if (cacheMetadataLayerObjectTemplate.getDigest() == null || cacheMetadataLayerObjectTemplate.getDiffId() == null) {
                    throw new IllegalStateException("Cannot translate cache metadata layer without a digest or diffId");
                }
                Path path2 = CacheFiles.getLayerFile(path, cacheMetadataLayerObjectTemplate.getDigest());
                CacheMetadataLayerPropertiesObjectTemplate cacheMetadataLayerPropertiesObjectTemplate = cacheMetadataLayerObjectTemplate.getProperties();
                LayerMetadata layerMetadata = null;
                if (cacheMetadataLayerPropertiesObjectTemplate != null) {
                    layerMetadata = new LayerMetadata(cacheMetadataLayerPropertiesObjectTemplate.getSourceFiles(), cacheMetadataLayerPropertiesObjectTemplate.getLastModifiedTime());
                }
                CachedLayer cachedLayer = new CachedLayer(path2, new BlobDescriptor(cacheMetadataLayerObjectTemplate.getSize(), cacheMetadataLayerObjectTemplate.getDigest()), cacheMetadataLayerObjectTemplate.getDiffId());
                CachedLayerWithMetadata cachedLayerWithMetadata = new CachedLayerWithMetadata(cachedLayer, layerMetadata);
                cacheMetadata.addLayer(cachedLayerWithMetadata);
            }
            return cacheMetadata;
        }
        catch (LayerPropertyNotFoundException layerPropertyNotFoundException) {
            throw new CacheMetadataCorruptedException(layerPropertyNotFoundException);
        }
    }

    static CacheMetadataTemplate toTemplate(CacheMetadata cacheMetadata) {
        CacheMetadataTemplate cacheMetadataTemplate = new CacheMetadataTemplate();
        for (CachedLayerWithMetadata cachedLayerWithMetadata : cacheMetadata.getLayers()) {
            CacheMetadataLayerObjectTemplate cacheMetadataLayerObjectTemplate = new CacheMetadataLayerObjectTemplate().setSize(cachedLayerWithMetadata.getBlobDescriptor().getSize()).setDigest(cachedLayerWithMetadata.getBlobDescriptor().getDigest()).setDiffId(cachedLayerWithMetadata.getDiffId());
            if (cachedLayerWithMetadata.getMetadata() != null) {
                cacheMetadataLayerObjectTemplate.setProperties(new CacheMetadataLayerPropertiesObjectTemplate().setSourceFiles(cachedLayerWithMetadata.getMetadata().getSourceFiles()).setLastModifiedTime(cachedLayerWithMetadata.getMetadata().getLastModifiedTime()));
            }
            cacheMetadataTemplate.addLayer(cacheMetadataLayerObjectTemplate);
        }
        return cacheMetadataTemplate;
    }
}

