/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blob;
import com.google.cloud.tools.jib.blob.BlobDescriptor;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePushStep;
import com.google.cloud.tools.jib.builder.steps.BuildImageStep;
import com.google.cloud.tools.jib.builder.steps.PushBlobStep;
import com.google.cloud.tools.jib.cache.CachedLayer;
import com.google.cloud.tools.jib.hash.CountingDigestOutputStream;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.json.ImageToJsonTranslator;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PushContainerConfigurationStep
implements AsyncStep<AsyncStep<PushBlobStep>>,
Callable<AsyncStep<PushBlobStep>> {
    private static final String DESCRIPTION = "Pushing container configuration";
    private final BuildConfiguration buildConfiguration;
    private final AuthenticatePushStep authenticatePushStep;
    private final BuildImageStep buildImageStep;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<AsyncStep<PushBlobStep>> listenableFuture;

    PushContainerConfigurationStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, AuthenticatePushStep authenticatePushStep, BuildImageStep buildImageStep) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.authenticatePushStep = authenticatePushStep;
        this.buildImageStep = buildImageStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{buildImageStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<AsyncStep<PushBlobStep>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public AsyncStep<PushBlobStep> call() throws ExecutionException {
        ListenableFuture listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{this.authenticatePushStep.getFuture(), NonBlockingSteps.get(this.buildImageStep).getFuture()}).call(this::afterBuildConfigurationFutureFuture, (Executor)this.listeningExecutorService);
        return () -> listenableFuture;
    }

    private PushBlobStep afterBuildConfigurationFutureFuture() throws ExecutionException, IOException {
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            Image<CachedLayer> image = NonBlockingSteps.get(NonBlockingSteps.get(this.buildImageStep));
            Blob blob = new ImageToJsonTranslator(image).getContainerConfigurationBlob();
            CountingDigestOutputStream countingDigestOutputStream = new CountingDigestOutputStream(ByteStreams.nullOutputStream());
            blob.writeTo(countingDigestOutputStream);
            BlobDescriptor blobDescriptor = countingDigestOutputStream.toBlobDescriptor();
            PushBlobStep pushBlobStep = new PushBlobStep(this.listeningExecutorService, this.buildConfiguration, this.authenticatePushStep, blobDescriptor, blob);
            return pushBlobStep;
        }
    }
}

