/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.Timer;
import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.blob.Blobs;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.cloud.tools.jib.builder.steps.AuthenticatePullStep;
import com.google.cloud.tools.jib.image.Image;
import com.google.cloud.tools.jib.image.Layer;
import com.google.cloud.tools.jib.image.LayerCountMismatchException;
import com.google.cloud.tools.jib.image.LayerPropertyNotFoundException;
import com.google.cloud.tools.jib.image.json.ContainerConfigurationTemplate;
import com.google.cloud.tools.jib.image.json.JsonToImageTranslator;
import com.google.cloud.tools.jib.image.json.ManifestTemplate;
import com.google.cloud.tools.jib.image.json.UnknownManifestFormatException;
import com.google.cloud.tools.jib.image.json.V21ManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.json.JsonTemplateMapper;
import com.google.cloud.tools.jib.registry.RegistryClient;
import com.google.cloud.tools.jib.registry.RegistryException;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class PullBaseImageStep
implements AsyncStep<Image<Layer>>,
Callable<Image<Layer>> {
    private static final String DESCRIPTION = "Pulling base image manifest";
    private final BuildConfiguration buildConfiguration;
    private final AuthenticatePullStep authenticatePullStep;
    private final ListenableFuture<Image<Layer>> listenableFuture;

    PullBaseImageStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, AuthenticatePullStep authenticatePullStep) {
        this.buildConfiguration = buildConfiguration;
        this.authenticatePullStep = authenticatePullStep;
        this.listenableFuture = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{authenticatePullStep.getFuture()}).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Image<Layer>> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Image<Layer> call() throws IOException, RegistryException, LayerPropertyNotFoundException, LayerCountMismatchException, ExecutionException {
        this.buildConfiguration.getBuildLogger().lifecycle("Getting base image " + this.buildConfiguration.getBaseImageReference() + "...");
        Throwable throwable = null;
        try (Timer timer = new Timer(this.buildConfiguration.getBuildLogger(), DESCRIPTION);){
            RegistryClient registryClient = new RegistryClient(NonBlockingSteps.get(this.authenticatePullStep), this.buildConfiguration.getBaseImageRegistry(), this.buildConfiguration.getBaseImageRepository());
            ManifestTemplate manifestTemplate = registryClient.pullManifest(this.buildConfiguration.getBaseImageTag());
            switch (manifestTemplate.getSchemaVersion()) {
                case 1: {
                    V21ManifestTemplate v21ManifestTemplate = (V21ManifestTemplate)manifestTemplate;
                    Image<Layer> image = JsonToImageTranslator.toImage(v21ManifestTemplate);
                    return image;
                }
                case 2: {
                    V22ManifestTemplate v22ManifestTemplate = (V22ManifestTemplate)manifestTemplate;
                    if (v22ManifestTemplate.getContainerConfiguration() == null || v22ManifestTemplate.getContainerConfiguration().getDigest() == null) {
                        throw new UnknownManifestFormatException("Invalid container configuration in Docker V2.2 manifest: \n" + Blobs.writeToString(JsonTemplateMapper.toBlob(v22ManifestTemplate)));
                    }
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    registryClient.pullBlob(v22ManifestTemplate.getContainerConfiguration().getDigest(), byteArrayOutputStream);
                    String string = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
                    ContainerConfigurationTemplate containerConfigurationTemplate = JsonTemplateMapper.readJson(string, ContainerConfigurationTemplate.class);
                    Image<Layer> image = JsonToImageTranslator.toImage(v22ManifestTemplate, containerConfigurationTemplate);
                    return image;
                }
            }
            try {
                throw new IllegalStateException("Unknown manifest schema version");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

