/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder.steps;

import com.google.cloud.tools.jib.async.AsyncStep;
import com.google.cloud.tools.jib.async.NonBlockingSteps;
import com.google.cloud.tools.jib.builder.BuildConfiguration;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

class FinalizingStep
implements AsyncStep<Void>,
Callable<Void> {
    private final BuildConfiguration buildConfiguration;
    private final List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> futureDependencyLists;
    private final ListeningExecutorService listeningExecutorService;
    private final ListenableFuture<Void> listenableFuture;

    FinalizingStep(ListeningExecutorService listeningExecutorService, BuildConfiguration buildConfiguration, List<AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>>> list, List<? extends AsyncStep<?>> list2) {
        this.listeningExecutorService = listeningExecutorService;
        this.buildConfiguration = buildConfiguration;
        this.futureDependencyLists = list;
        ArrayList<Object> arrayList = new ArrayList<Object>(list.size() + list2.size());
        for (AsyncStep<ImmutableList<AsyncStep<?>>> asyncStep : list) {
            arrayList.add(asyncStep.getFuture());
        }
        for (AsyncStep<Object> asyncStep : list2) {
            arrayList.add(asyncStep.getFuture());
        }
        this.listenableFuture = Futures.whenAllSucceed(arrayList).call((Callable)this, (Executor)listeningExecutorService);
    }

    @Override
    public ListenableFuture<Void> getFuture() {
        return this.listenableFuture;
    }

    @Override
    public Void call() throws ExecutionException {
        ArrayList arrayList = new ArrayList();
        for (AsyncStep<? extends ImmutableList<? extends AsyncStep<?>>> asyncStep : this.futureDependencyLists) {
            for (AsyncStep asyncStep2 : NonBlockingSteps.get(asyncStep)) {
                arrayList.add(asyncStep2.getFuture());
            }
        }
        Futures.whenAllSucceed(arrayList).call(() -> {
            this.buildConfiguration.getBuildLogger().lifecycle("Finalizing...");
            return null;
        }, (Executor)this.listeningExecutorService);
        return null;
    }
}

