/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.tools.jib.builder;

import com.google.cloud.tools.jib.builder.BuildLogger;
import com.google.cloud.tools.jib.image.ImageReference;
import com.google.cloud.tools.jib.image.json.BuildableManifestTemplate;
import com.google.cloud.tools.jib.image.json.V22ManifestTemplate;
import com.google.cloud.tools.jib.registry.credentials.RegistryCredentials;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.lang.model.SourceVersion;

public class BuildConfiguration {
    private final BuildLogger buildLogger;
    private final ImageReference baseImageReference;
    @Nullable
    private final String baseImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownBaseRegistryCredentials;
    private final ImageReference targetImageReference;
    @Nullable
    private final String targetImageCredentialHelperName;
    @Nullable
    private final RegistryCredentials knownTargetRegistryCredentials;
    private final String mainClass;
    private final ImmutableList<String> javaArguments;
    private final ImmutableList<String> jvmFlags;
    private final ImmutableMap<String, String> environmentMap;
    private final Class<? extends BuildableManifestTemplate> targetFormat;

    public static boolean isValidJavaClass(String string) {
        for (String string2 : Splitter.on((char)'.').split((CharSequence)string)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    public static Builder builder(BuildLogger buildLogger) {
        return new Builder(buildLogger);
    }

    private BuildConfiguration(BuildLogger buildLogger, ImageReference imageReference, @Nullable String string, @Nullable RegistryCredentials registryCredentials, ImageReference imageReference2, @Nullable String string2, @Nullable RegistryCredentials registryCredentials2, String string3, ImmutableList<String> immutableList, ImmutableList<String> immutableList2, ImmutableMap<String, String> immutableMap, Class<? extends BuildableManifestTemplate> clazz) {
        this.buildLogger = buildLogger;
        this.baseImageReference = imageReference;
        this.baseImageCredentialHelperName = string;
        this.knownBaseRegistryCredentials = registryCredentials;
        this.targetImageReference = imageReference2;
        this.targetImageCredentialHelperName = string2;
        this.knownTargetRegistryCredentials = registryCredentials2;
        this.mainClass = string3;
        this.javaArguments = immutableList;
        this.jvmFlags = immutableList2;
        this.environmentMap = immutableMap;
        this.targetFormat = clazz;
    }

    public BuildLogger getBuildLogger() {
        return this.buildLogger;
    }

    public ImageReference getBaseImageReference() {
        return this.baseImageReference;
    }

    public String getBaseImageRegistry() {
        return this.baseImageReference.getRegistry();
    }

    public String getBaseImageRepository() {
        return this.baseImageReference.getRepository();
    }

    public String getBaseImageTag() {
        return this.baseImageReference.getTag();
    }

    @Nullable
    public String getBaseImageCredentialHelperName() {
        return this.baseImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownBaseRegistryCredentials() {
        return this.knownBaseRegistryCredentials;
    }

    public ImageReference getTargetImageReference() {
        return this.targetImageReference;
    }

    public String getTargetImageRegistry() {
        return this.targetImageReference.getRegistry();
    }

    public String getTargetImageRepository() {
        return this.targetImageReference.getRepository();
    }

    public String getTargetImageTag() {
        return this.targetImageReference.getTag();
    }

    @Nullable
    public String getTargetImageCredentialHelperName() {
        return this.targetImageCredentialHelperName;
    }

    @Nullable
    public RegistryCredentials getKnownTargetRegistryCredentials() {
        return this.knownTargetRegistryCredentials;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public ImmutableList<String> getJavaArguments() {
        return this.javaArguments;
    }

    public ImmutableList<String> getJvmFlags() {
        return this.jvmFlags;
    }

    public ImmutableMap<String, String> getEnvironment() {
        return this.environmentMap;
    }

    public Class<? extends BuildableManifestTemplate> getTargetFormat() {
        return this.targetFormat;
    }

    public static class Builder {
        @Nullable
        private ImageReference baseImageReference;
        @Nullable
        private String baseImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownBaseRegistryCredentials;
        @Nullable
        private ImageReference targetImageReference;
        @Nullable
        private String targetImageCredentialHelperName;
        @Nullable
        private RegistryCredentials knownTargetRegistryCredentials;
        @Nullable
        private String mainClass;
        private List<String> javaArguments = new ArrayList<String>();
        private List<String> jvmFlags = new ArrayList<String>();
        private Map<String, String> environmentMap = new HashMap<String, String>();
        private Class<? extends BuildableManifestTemplate> targetFormat = V22ManifestTemplate.class;
        private BuildLogger buildLogger;

        private Builder(BuildLogger buildLogger) {
            this.buildLogger = buildLogger;
        }

        public Builder setBaseImage(@Nullable ImageReference imageReference) {
            this.baseImageReference = imageReference;
            return this;
        }

        public Builder setTargetImage(@Nullable ImageReference imageReference) {
            this.targetImageReference = imageReference;
            return this;
        }

        public Builder setBaseImageCredentialHelperName(@Nullable String string) {
            this.baseImageCredentialHelperName = string;
            return this;
        }

        public Builder setTargetImageCredentialHelperName(@Nullable String string) {
            this.targetImageCredentialHelperName = string;
            return this;
        }

        public Builder setKnownBaseRegistryCredentials(@Nullable RegistryCredentials registryCredentials) {
            this.knownBaseRegistryCredentials = registryCredentials;
            return this;
        }

        public Builder setKnownTargetRegistryCredentials(@Nullable RegistryCredentials registryCredentials) {
            this.knownTargetRegistryCredentials = registryCredentials;
            return this;
        }

        public Builder setMainClass(@Nullable String string) {
            this.mainClass = string;
            return this;
        }

        public Builder setJavaArguments(@Nullable List<String> list) {
            if (list != null) {
                this.javaArguments = list;
            }
            return this;
        }

        public Builder setJvmFlags(@Nullable List<String> list) {
            if (list != null) {
                this.jvmFlags = list;
            }
            return this;
        }

        public Builder setEnvironment(@Nullable Map<String, String> map) {
            if (map != null) {
                this.environmentMap = map;
            }
            return this;
        }

        public Builder setTargetFormat(Class<? extends BuildableManifestTemplate> clazz) {
            this.targetFormat = clazz;
            return this;
        }

        public BuildConfiguration build() {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.baseImageReference == null) {
                arrayList.add("base image is required but not set");
            }
            if (this.targetImageReference == null) {
                arrayList.add("target image is required but not set");
            }
            if (this.mainClass == null) {
                arrayList.add("main class is required but not set");
            }
            switch (arrayList.size()) {
                case 0: {
                    if (this.baseImageReference == null || this.targetImageReference == null || this.mainClass == null) {
                        throw new IllegalStateException("Required fields should not be null");
                    }
                    if (this.baseImageReference.usesDefaultTag()) {
                        this.buildLogger.warn("Base image '" + this.baseImageReference + "' does not use a specific image digest - build may not be reproducible");
                    }
                    return new BuildConfiguration(this.buildLogger, this.baseImageReference, this.baseImageCredentialHelperName, this.knownBaseRegistryCredentials, this.targetImageReference, this.targetImageCredentialHelperName, this.knownTargetRegistryCredentials, this.mainClass, ImmutableList.copyOf(this.javaArguments), ImmutableList.copyOf(this.jvmFlags), ImmutableMap.copyOf(this.environmentMap), this.targetFormat);
                }
                case 1: {
                    throw new IllegalStateException((String)arrayList.get(0));
                }
                case 2: {
                    throw new IllegalStateException((String)arrayList.get(0) + " and " + (String)arrayList.get(1));
                }
            }
            StringBuilder stringBuilder = new StringBuilder((String)arrayList.get(0));
            for (int i = 1; i < arrayList.size(); ++i) {
                if (i == arrayList.size() - 1) {
                    stringBuilder.append(", and ");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)arrayList.get(i));
            }
            throw new IllegalStateException(stringBuilder.toString());
        }
    }
}

