/*
 * Decompiled with CFR 0.152.
 */
package de.gccc.jib.common;

import com.google.cloud.tools.jib.api.Containerizer;
import com.google.cloud.tools.jib.api.Credential;
import com.google.cloud.tools.jib.api.CredentialRetriever;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.api.JavaContainerBuilder;
import com.google.cloud.tools.jib.api.JibContainer;
import com.google.cloud.tools.jib.api.JibContainerBuilder;
import com.google.cloud.tools.jib.api.LogEvent;
import com.google.cloud.tools.jib.api.RegistryImage;
import com.google.cloud.tools.jib.api.buildplan.ImageFormat;
import com.google.cloud.tools.jib.api.buildplan.Platform;
import com.google.cloud.tools.jib.api.buildplan.Port;
import com.google.cloud.tools.jib.frontend.CredentialRetrieverFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.compat.java8.FunctionConverters.package$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsConsumer$;
import scala.compat.java8.functionConverterImpls.RichFunction1AsPredicate$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class JibCommon$ {
    public static JibCommon$ MODULE$;

    static {
        new JibCommon$();
    }

    private boolean isSnapshotDependency(Path path) {
        return ((Object)path).toString().endsWith("-SNAPSHOT.jar");
    }

    public void prepareJavaContainerBuilder(JavaContainerBuilder builder, List<Path> externalDependencies, List<Path> otherFilesToClasspath, List<Path> internalDependencies, List<Path> resourceFilesDirectories, List<Path> classFilesDirectories, Option<String> mainClass, List<String> jvmFlags) {
        builder.addDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)externalDependencies.filterNot((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.MODULE$.isSnapshotDependency(path)))).asJava());
        builder.addSnapshotDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)externalDependencies.filter((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.MODULE$.isSnapshotDependency(path)))).asJava());
        builder.addToClasspath((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(otherFilesToClasspath).asJava());
        builder.addProjectDependencies((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(internalDependencies).asJava());
        ((List)resourceFilesDirectories.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.$anonfun$prepareJavaContainerBuilder$3(x$1)))).foreach((Function1 & Serializable & scala.Serializable)x$1 -> builder.addResources(x$1));
        ((List)classFilesDirectories.filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.$anonfun$prepareJavaContainerBuilder$5(x$2)))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> builder.addClasses(x$3, RichFunction1AsPredicate$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaPredicate((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JibCommon$.$anonfun$prepareJavaContainerBuilder$7(p))))));
        builder.setMainClass((String)mainClass.orNull(Predef$.MODULE$.$conforms()));
        builder.addJvmFlags((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(jvmFlags).asJava());
    }

    public JibContainerBuilder prepareJibContainerBuilder(JibContainerBuilder builder, scala.collection.immutable.Set<Port> ports, List<String> args, ImageFormat internalImageFormat, scala.collection.immutable.Map<String, String> environment, scala.collection.immutable.Map<String, String> labels, Option<String> user, boolean useCurrentTimestamp, scala.collection.immutable.Set<Platform> platforms) {
        return builder.setEnvironment((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(environment).asJava()).setPlatforms((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(platforms).asJava()).setLabels((Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(labels).asJava()).setUser((String)user.orNull(Predef$.MODULE$.$conforms())).setProgramArguments((java.util.List)CollectionConverters$.MODULE$.seqAsJavaListConverter(args).asJava()).setFormat(internalImageFormat).setExposedPorts((Set)CollectionConverters$.MODULE$.setAsJavaSetConverter(ports).asJava()).setCreationTime(this.useCurrentTimestamp(useCurrentTimestamp));
    }

    private RegistryImage imageFactory(ImageReference imageReference, Tuple2<String, String> credentialsEnv, Option<String> credHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        RegistryImage image = RegistryImage.named((ImageReference)imageReference);
        CredentialRetrieverFactory factory = CredentialRetrieverFactory.forImage((ImageReference)imageReference, (Consumer)RichFunction1AsConsumer$.MODULE$.asJava$extension(package$.MODULE$.enrichAsJavaConsumer(logger)));
        Tuple2<String, String> tuple2 = credentialsEnv;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String usernameEnv = (String)tuple2._1();
        String passwordEnv = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)usernameEnv, (Object)passwordEnv);
        Tuple2 tuple23 = tuple22;
        String usernameEnv2 = (String)tuple23._1();
        String passwordEnv2 = (String)tuple23._2();
        image.addCredentialRetriever(this.retrieveEnvCredentials(usernameEnv2, passwordEnv2));
        image.addCredentialRetriever(this.retrieveSbtCredentials(imageReference, credsForHost));
        image.addCredentialRetriever(factory.dockerConfig());
        image.addCredentialRetriever(factory.wellKnownCredentialHelpers());
        image.addCredentialRetriever(factory.googleApplicationDefaultCredentials());
        credHelper.foreach((Function1 & Serializable & scala.Serializable)helper -> image.addCredentialRetriever(factory.dockerCredentialHelper(helper)));
        return image;
    }

    private CredentialRetriever retrieveEnvCredentials(String usernameEnv, String passwordEnv) {
        return new CredentialRetriever(usernameEnv, passwordEnv){
            private final String usernameEnv$1;
            private final String passwordEnv$1;

            public Optional<Credential> retrieve() {
                Option option = scala.sys.package$.MODULE$.env().get((Object)this.usernameEnv$1).flatMap((Function1 & Serializable & scala.Serializable)username -> scala.sys.package$.MODULE$.env().get((Object)$this.passwordEnv$1).map((Function1 & Serializable & scala.Serializable)password -> Credential.from((String)username, (String)password)));
                return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(option));
            }
            {
                this.usernameEnv$1 = usernameEnv$1;
                this.passwordEnv$1 = passwordEnv$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$retrieve$1(de.gccc.jib.common.JibCommon$$anon$1 java.lang.String ), $anonfun$retrieve$2(java.lang.String java.lang.String )}, serializedLambda);
            }
        };
    }

    private CredentialRetriever retrieveSbtCredentials(ImageReference imageReference, Function1<String, Option<Tuple2<String, String>>> credsForHost) {
        return new CredentialRetriever(credsForHost, imageReference){
            private final Function1 credsForHost$1;
            private final ImageReference imageReference$1;

            public Optional<Credential> retrieve() {
                Option option = ((Option)this.credsForHost$1.apply((Object)this.imageReference$1.getRegistry())).map(((Function2 & Serializable & scala.Serializable)(Function2 & Serializable & scala.Serializable)(x$1, x$2) -> Credential.from((String)x$1, (String)x$2)).tupled());
                return OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(option));
            }
            {
                this.credsForHost$1 = credsForHost$1;
                this.imageReference$1 = imageReference$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$retrieve$3(java.lang.String java.lang.String )}, serializedLambda);
            }
        };
    }

    public RegistryImage baseImageFactory(ImageReference baseImageReference, Option<String> jibBaseImageCredentialHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        return this.imageFactory(baseImageReference, (Tuple2<String, String>)new Tuple2((Object)"JIB_BASE_IMAGE_USERNAME", (Object)"JIB_BASE_IMAGE_PASSWORD"), jibBaseImageCredentialHelper, credsForHost, logger);
    }

    public RegistryImage targetImageFactory(ImageReference targetImageReference, Option<String> jibTargetImageCredentialHelper, Function1<String, Option<Tuple2<String, String>>> credsForHost, Function1<LogEvent, BoxedUnit> logger) {
        return this.imageFactory(targetImageReference, (Tuple2<String, String>)new Tuple2((Object)"JIB_TARGET_IMAGE_USERNAME", (Object)"JIB_TARGET_IMAGE_PASSWORD"), jibTargetImageCredentialHelper, credsForHost, logger);
    }

    public void configureContainerizer(Containerizer containerizer, List<String> additionalTags, boolean allowInsecureRegistries, String USER_AGENT_SUFFIX, Path target) {
        additionalTags.foldRight((Object)containerizer, (Function2 & Serializable & scala.Serializable)(tag, image) -> image.withAdditionalTag(tag));
        containerizer.setAllowInsecureRegistries(allowInsecureRegistries).setToolName(USER_AGENT_SUFFIX).setApplicationLayersCache(target.resolve("application-layer-cache")).setBaseImageLayersCache(target.resolve("base-image-layer-cache"));
    }

    public void writeJibOutputFiles(JibContainer container, Path targetDirectory) {
        Files.write(targetDirectory.resolve("jib-image.digest"), container.getDigest().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        Files.write(targetDirectory.resolve("jib-image.id"), container.getImageId().toString().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String jsonString = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(121).append("{\n         |   \"image\": \"").append(container.getTargetImage()).append("\",\n         |   \"imageId\": \"").append(container.getImageId()).append("\",\n         |   \"imageDigest\": \"").append(container.getDigest()).append("\",\n         |   \"tags\": ").append(((TraversableOnce)CollectionConverters$.MODULE$.asScalaSetConverter(container.getTags()).asScala()).mkString("[\"", "\", \"", "\"]")).append("\n         |}").toString())).stripMargin();
        Files.write(targetDirectory.resolve("jib-image.json"), jsonString.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void setSendCredentialsOverHttp(boolean sendCredentialsOverHttp) {
        System.setProperty("sendCredentialsOverHttp", Boolean.toString(sendCredentialsOverHttp));
    }

    public Instant useCurrentTimestamp(boolean useCurrentTimestamp) {
        return useCurrentTimestamp ? Instant.now() : Instant.EPOCH;
    }

    public static final /* synthetic */ boolean $anonfun$prepareJavaContainerBuilder$3(Path x$1) {
        return x$1.toFile().exists();
    }

    public static final /* synthetic */ boolean $anonfun$prepareJavaContainerBuilder$5(Path x$2) {
        return x$2.toFile().exists();
    }

    public static final /* synthetic */ boolean $anonfun$prepareJavaContainerBuilder$7(Path p) {
        return ((Object)p).toString().endsWith(".class");
    }

    private JibCommon$() {
        MODULE$ = this;
    }
}

