/*
 * Decompiled with CFR 0.152.
 */
package de.garrus.maven.minecraftserverplugin.mojo;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import de.garrus.maven.minecraftserverplugin.ServerType;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="server-install", requiresOnline=true)
public class InstallMojo
extends AbstractMojo {
    private static final String PAPER_API = "https://papermc.io/api/v1/paper/";
    @Parameter(name="serverType")
    private ServerType type = ServerType.PAPER;
    @Parameter(name="serverFolder")
    private File serverFolder = new File("target/mc_server/");
    @Parameter(name="serverVersion")
    private String serverVersion = "1.15.2";
    @Parameter(name="createEula")
    private boolean createEula = false;
    @Parameter(name="overrideServerJar")
    private boolean overrideServerJar = false;
    @Parameter(name="reinstallServer")
    private boolean reinstallServer = false;
    @Parameter(name="resetWorld")
    private boolean resetWorld = false;
    @Parameter(name="cleanPluginFolder")
    private boolean cleanPluginFolder = false;
    private File serverFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.serverFile = new File(this.serverFolder, "server.jar");
        if (this.reinstallServer) {
            this.cleanServerFolder();
        }
        if (this.resetWorld) {
            this.resetWorld();
        }
        if (this.cleanPluginFolder) {
            this.cleanPluginFolder();
        }
        if (!this.serverFile.exists() || this.overrideServerJar) {
            this.serverFolder.mkdirs();
            this.downloadServer();
            if (this.createEula) {
                this.createEula();
            }
        } else {
            this.getLog().info((CharSequence)"Server already installed. Skip Installer.");
        }
    }

    private void cleanPluginFolder() {
        try {
            FileUtils.deleteDirectory((File)new File(this.serverFolder, "plugins/"));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't delete the plugin folder", (Throwable)e);
        }
    }

    private void cleanServerFolder() {
        try {
            FileUtils.deleteDirectory((File)this.serverFolder);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't delete the server folder", (Throwable)e);
        }
        this.serverFolder.mkdirs();
    }

    private void resetWorld() {
        try {
            FileUtils.deleteDirectory((File)new File(this.serverFolder, "world"));
            FileUtils.deleteDirectory((File)new File(this.serverFolder, "world_the_end"));
            FileUtils.deleteDirectory((File)new File(this.serverFolder, "world_nether"));
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't delete the world Folder", (Throwable)e);
        }
    }

    private void createEula() {
        File eulaFile = new File(this.serverFolder, "eula.txt");
        if (!eulaFile.exists()) {
            try {
                FileWriter eulaWriter = new FileWriter(eulaFile);
                eulaWriter.write("eula=true");
                eulaWriter.flush();
                eulaWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Can't write the Server Eula File", (Throwable)e);
            }
        }
    }

    private void downloadServer() {
        switch (this.type) {
            case PAPER: {
                this.downloadServerJar(this.getPaperServerDownload());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Server Type current not supported.");
            }
        }
    }

    private void downloadServerJar(URL downloadUrl) {
        try {
            InputStream serverJarStream = downloadUrl.openStream();
            FileUtils.copyInputStreamToFile((InputStream)serverJarStream, (File)this.serverFile);
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't load the Server Jar form the Server.", (Throwable)e);
        }
    }

    public URL getPaperServerDownload() {
        try {
            URL paperApiURL = new URL(PAPER_API + this.serverVersion);
            JsonObject versionJson = (JsonObject)new Gson().fromJson((Reader)new InputStreamReader(paperApiURL.openStream()), JsonObject.class);
            if (versionJson.has("builds")) {
                String buildVersion = versionJson.get("builds").getAsJsonObject().get("latest").getAsString();
                return new URL(PAPER_API + this.serverVersion + "/" + buildVersion + "/download");
            }
            this.getLog().error((CharSequence)"Can't find the build version in the api json");
            return null;
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't connect to the Papermc.io Server.", (Throwable)e);
            return null;
        }
    }
}

