/*
 * Decompiled with CFR 0.152.
 */
package de.garrus.maven.minecraftserverplugin.mojo;

import de.garrus.maven.minecraftserverplugin.ServerType;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="server-start")
public class StartMojo
extends AbstractMojo {
    @Parameter(name="serverType")
    private ServerType type = ServerType.PAPER;
    @Parameter(name="serverFolder")
    private File serverFolder = new File("target/mc_server/");
    @Parameter(name="serverVersion")
    private String serverVersion = "1.15.2";
    @Parameter(name="jarName", defaultValue="${project.build.finalName}")
    private String jarName;
    @Parameter(name="targetFolder", readonly=true, defaultValue="${project.build.directory}")
    private File targetFolder;
    @Parameter(name="skipPluginCopy", defaultValue="false")
    private boolean skipPluginCopy;
    private File serverFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.serverFile = new File(this.serverFolder, "server.jar");
        if (this.serverFile.exists()) {
            if (!this.skipPluginCopy) {
                this.copyPluginToServer();
            }
        } else {
            throw new MojoFailureException("Server is not installed.");
        }
        this.startServer();
    }

    private void copyPluginToServer() throws MojoFailureException {
        File pluginJar = new File(this.targetFolder, this.jarName + ".jar");
        if (pluginJar.exists()) {
            try {
                FileUtils.copyFile((File)pluginJar, (File)new File(this.serverFolder, "plugins/plugin.jar"));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Can't copy the plugin File.", (Throwable)e);
            }
        } else {
            throw new MojoFailureException("Can't copy the Plugin Jar.");
        }
    }

    private void startServer() {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("java", "-jar", "server.jar", "nogui");
            processBuilder.directory(this.serverFolder);
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectInput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
            processBuilder.start().waitFor();
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error((CharSequence)"Can't start the server", (Throwable)e);
        }
    }
}

