/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import de.galan.commons.func.exceptional.ExceptionalRunnable;
import de.galan.commons.logging.Say;
import de.galan.commons.time.Durations;
import de.galan.commons.time.Sleeper;
import de.galan.commons.util.RetryException;
import de.galan.commons.util.Sugar;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import org.apache.commons.lang3.StringUtils;

public class Retryable {
    public static final String DEFAULT_WAIT_TIME = "1s";
    public static final long INFINITE = -1L;
    private long numberOfRetries;
    private long numberOfTriesLeft;
    private String timeToWait;
    private String message;

    Retryable(long numberOfRetries) {
        this.retries(numberOfRetries);
    }

    public static Retryable retry(long numberOfRetries) {
        return new Retryable(numberOfRetries);
    }

    public static Retryable infinite() {
        return new Retryable(-1L);
    }

    public Retryable timeToWait(String timeToWaitBetween) {
        this.timeToWait = timeToWaitBetween;
        return this;
    }

    public Retryable timeToWait(long millis) {
        this.timeToWait = Durations.humanize(millis);
        return this;
    }

    public Retryable retries(long retries) {
        this.numberOfRetries = retries;
        this.numberOfTriesLeft = this.numberOfRetries + 1L;
        return this;
    }

    public Retryable message(String msg) {
        this.message = msg;
        return this;
    }

    public <V> V call(Callable<V> callable) throws Exception {
        while (Thread.currentThread().isAlive()) {
            try {
                return callable.call();
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (CancellationException e) {
                throw e;
            }
            catch (Exception e) {
                --this.numberOfTriesLeft;
                if (this.numberOfRetries != -1L) {
                    if (this.numberOfTriesLeft == 0L) {
                        throw new RetryException(this.numberOfRetries + " attempts to retry, failed at " + this.timeToWait + " interval for " + this.message, e, this.numberOfRetries, this.timeToWait, this.message);
                    }
                    if (StringUtils.isBlank((CharSequence)this.message)) {
                        Say.info((Object)"Retrying {numberOfRetriesLeft}/{numberOfRetries} in {timeToWait}", this.numberOfRetries - this.numberOfTriesLeft + 1L, this.numberOfRetries, this.timeToWait);
                    } else {
                        Say.info((Object)"Retrying {numberOfRetriesLeft}/{numberOfRetries} in {timeToWait} for {message}", this.numberOfRetries - this.numberOfTriesLeft + 1L, this.numberOfRetries, this.timeToWait, this.message);
                    }
                } else if (StringUtils.isBlank((CharSequence)this.message)) {
                    Say.info((Object)"Retrying {} in {}", Math.abs(this.numberOfTriesLeft + 1L), this.timeToWait);
                } else {
                    Say.info((Object)"Retrying {} in {} for {}", Math.abs(this.numberOfTriesLeft + 1L), this.timeToWait, this.message);
                }
                Sleeper.sleep(Sugar.optional(this.timeToWait).orElse(DEFAULT_WAIT_TIME));
            }
        }
        throw new InterruptedException("Thread with retry is not longer alive");
    }

    public void run(ExceptionalRunnable runnable) throws Exception {
        this.call(() -> {
            runnable.run();
            return null;
        });
    }
}

