/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import de.galan.commons.logging.Say;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MessageBox {
    private static final int WIDTH = 68;
    private static final Pattern LINEBREAK = Pattern.compile("\\r?\\n");

    public static void printBox(String title, String message) {
        MessageBox.printBox(title, Splitter.on((Pattern)LINEBREAK).splitToList((CharSequence)message));
    }

    public static void printBox(String title, List<String> messageLines) {
        Say.info((Object)"{message}", MessageBox.generateBox(title, messageLines));
    }

    protected static String generateBox(String title, List<String> messageLines) {
        String lf = StandardSystemProperty.LINE_SEPARATOR.value();
        String indention = "\t";
        StringBuilder info = new StringBuilder(lf);
        if (StringUtils.isNotBlank((CharSequence)title)) {
            info.append(indention + "\u256d" + StringUtils.repeat((String)"\u2500", (int)68) + "\u256e" + lf);
            info.append(indention + "\u2502" + StringUtils.repeat((String)" ", (int)68) + "\u2502" + lf);
            info.append(indention + StringUtils.rightPad((String)("\u2502    " + title), (int)69, (String)" ") + "\u2502" + lf);
            info.append(indention + "\u255e\u2550\u2550\u2550\u2550" + StringUtils.repeat((String)"\u2550", (int)60) + "\u2550\u2550\u2550\u2550\u255b" + lf);
        } else {
            info.append(indention + "\u256d" + StringUtils.repeat((String)"\u2500", (int)68) + "\u2504" + lf);
        }
        info.append(indention + "\u2502" + lf);
        for (String line : messageLines) {
            info.append(indention + "\u2502    " + line + lf);
        }
        info.append(indention + "\u2502" + lf);
        info.append(indention + "\u2570" + StringUtils.repeat((String)"\u2500", (int)68) + "\u2504" + lf);
        return info.toString();
    }
}

