/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import com.google.common.base.Preconditions;
import de.galan.commons.func.exceptional.ExceptionalRunnable;
import de.galan.commons.logging.Say;
import de.galan.commons.time.Durations;
import de.galan.commons.util.Sugar;
import java.util.concurrent.Callable;
import java.util.stream.LongStream;

public class Measure {
    private Integer builderIteratons;
    private String builderWhat;
    private int counter = 0;
    private long[] times;
    private Long startMeasure;

    public static Measure measure(String what) {
        return new Measure(what, null);
    }

    Measure(String what, Integer iterations) {
        this.builderWhat = what;
        this.builderIteratons = iterations;
        Preconditions.checkState((iterations == null || iterations >= 0 ? 1 : 0) != 0, (Object)"iterations must be non-negative or null");
        Integer n = this.builderIteratons = iterations == null || (long)iterations.intValue() <= 1L ? null : iterations;
        if (iterations != null) {
            this.times = new long[Sugar.optional(iterations).orElse(0).intValue()];
        }
    }

    public Measure every(Integer iterations) {
        return new Measure(this.builderWhat, iterations);
    }

    public void finish() {
        if (this.startMeasure == null) {
            Say.info("No invokations are measured");
        } else {
            long total = System.currentTimeMillis() - this.startMeasure;
            double average = 1.0 * (double)total / (double)this.counter;
            this.logFinished(total, average);
        }
    }

    public Measure total(boolean total) {
        return new Measure(this.builderWhat, this.builderIteratons);
    }

    public void runnable(Runnable runnable) {
        this.initStartTotal();
        long startInvokation = System.currentTimeMillis();
        runnable.run();
        this.invoked(System.currentTimeMillis() - startInvokation);
    }

    public void run(ExceptionalRunnable runnable) throws Exception {
        this.initStartTotal();
        long startInvokation = System.currentTimeMillis();
        runnable.run();
        this.invoked(System.currentTimeMillis() - startInvokation);
    }

    public <V> V call(Callable<V> callable) throws Exception {
        this.initStartTotal();
        long startInvokation = System.currentTimeMillis();
        V result = callable.call();
        this.invoked(System.currentTimeMillis() - startInvokation);
        return result;
    }

    private void initStartTotal() {
        if (this.startMeasure == null) {
            this.startMeasure = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoked(long millis) {
        if (this.builderIteratons == null) {
            ++this.counter;
            this.log(millis);
        } else {
            Measure measure = this;
            synchronized (measure) {
                this.times[this.counter++ % this.builderIteratons.intValue()] = millis;
                if (this.counter % this.builderIteratons == 0) {
                    double average = 1.0 * (double)LongStream.of(this.times).sum() / (double)this.builderIteratons.intValue();
                    this.log(average);
                    this.times = new long[this.builderIteratons.intValue()];
                }
            }
        }
    }

    void logFinished(long total, double average) {
        Say.info((Object)"Measured {what} finished in {total}ms, took on average ~{time}ms in {iterations} iterations", this.builderWhat, total, String.format("%.2f", average), this.counter);
    }

    void log(double average) {
        Say.info((Object)"Measured {what} took on average ~{time}ms after {iterations} iterations", this.builderWhat, String.format("%.2f", average), this.counter);
    }

    void log(long millis) {
        Say.info((Object)"Measured {what} took {time}ms, that's {}", this.builderWhat, millis, Durations.humanize(millis, " "));
    }
}

