/*
 * Decompiled with CFR 0.152.
 */
package de.galan.commons.util;

import de.galan.commons.logging.Say;
import de.galan.commons.time.Sleeper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import org.apache.commons.lang3.StringUtils;

public class JvmUtil {
    public static String getPid() {
        return Long.toString(ProcessHandle.current().pid());
    }

    public static String getMachineName() {
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        return rmxb.getName().split("@")[1];
    }

    public static long getUptime() {
        RuntimeMXBean rmxb = ManagementFactory.getRuntimeMXBean();
        return rmxb.getUptime();
    }

    public static TerminateBuilder terminate() {
        return new TerminateBuilder();
    }

    public static synchronized void addShutdownHook(Runnable task) {
        if (task != null) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    task.run();
                }
                catch (RuntimeException rex) {
                    Say.warn((Object)"Exception while processing shutdown-hook", rex);
                }
            }));
        }
    }

    public static class TerminateBuilder {
        private int builderReturnCode;
        private boolean builderThreaded = false;
        private String builderMessage;

        public TerminateBuilder returnCode(int returnCode) {
            this.builderReturnCode = returnCode;
            return this;
        }

        public TerminateBuilder threaded(boolean threaded) {
            this.builderThreaded = threaded;
            return this;
        }

        public TerminateBuilder message(String message) {
            this.builderMessage = message;
            return this;
        }

        public void in(String time) {
            this.shutdown(time);
        }

        public void now() {
            this.shutdown(null);
        }

        protected void shutdown(String time) {
            if (this.builderThreaded) {
                Thread thread = new Thread(() -> this.shutdownFinal(time), "JvmTermination-thread");
                thread.setDaemon(true);
                thread.start();
            } else {
                this.shutdownFinal(time);
            }
        }

        protected String getMessage() {
            return StringUtils.isNotBlank((CharSequence)this.builderMessage) ? this.builderMessage : "none";
        }

        protected void shutdownFinal(String time) {
            if (time != null) {
                Say.info((Object)"The JavaVM will exit in {time}, return code will be {code}, message: {message}", time, this.builderReturnCode, this.getMessage());
                Sleeper.sleep(time);
            }
            Say.info((Object)"The JavaVM will exit NOW, return code is {code}, message: {message}", this.builderReturnCode, this.getMessage());
            System.exit(this.builderReturnCode);
        }
    }
}

